/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.config;

import com.qq.tars.common.support.Endpoint;
import com.qq.tars.common.util.Config;

public class ServantAdapterConfig {
    private Endpoint endpoint = null;
    private int maxConns = 128;
    private int queueCap = 1024;
    private int queueTimeout = 10000;
    private String servant = null;
    private String protocol = "tars";
    private int threads = 1;
    private String handleGroup = null;

    public ServantAdapterConfig load(Config conf, String adapterName) {
        String path = "/tars/application/server/" + adapterName;
        this.endpoint = Endpoint.parseString(conf.get(path + "<endpoint>"));
        this.handleGroup = conf.get(path + "<handlegroup>", null);
        this.protocol = conf.get(path + "<protocol>", "tars");
        this.maxConns = conf.getInt(path + "<maxconns>", 128);
        this.queueCap = conf.getInt(path + "<queuecap>", 1024);
        this.queueTimeout = conf.getInt(path + "<queuetimeout>", 10000);
        this.servant = conf.get(path + "<servant>");
        this.threads = conf.getInt(path + "<threads>", 1);
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ServantAdapterConfig setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public int getMaxConns() {
        return this.maxConns;
    }

    public ServantAdapterConfig setMaxConns(int maxConns) {
        this.maxConns = maxConns;
        return this;
    }

    public int getQueueCap() {
        return this.queueCap;
    }

    public ServantAdapterConfig setQueueCap(int queueCap) {
        this.queueCap = queueCap;
        return this;
    }

    public int getQueueTimeout() {
        return this.queueTimeout;
    }

    public ServantAdapterConfig setQueueTimeout(int queueTimeout) {
        this.queueTimeout = queueTimeout;
        return this;
    }

    public String getServant() {
        return this.servant;
    }

    public ServantAdapterConfig setServant(String servant) {
        this.servant = servant;
        return this;
    }

    public int getThreads() {
        return this.threads;
    }

    public ServantAdapterConfig setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ServantAdapterConfig setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getHandleGroup() {
        return this.handleGroup;
    }

    public ServantAdapterConfig setHandleGroup(String handleGroup) {
        this.handleGroup = handleGroup;
        return this;
    }
}

