/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc.loadbalance;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.rpc.loadbalance.ConsistentHashLoadBalance;
import com.qq.tars.client.rpc.loadbalance.HashLoadBalance;
import com.qq.tars.client.rpc.loadbalance.RoundRobinLoadBalance;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.exc.NoInvokerException;
import java.util.Collection;

public class DefaultLoadBalance<T>
implements LoadBalance<T> {
    private final RoundRobinLoadBalance<T> roundRobinLoadBalance;
    private final ServantProxyConfig config;
    private volatile Collection<Invoker<T>> lastRefreshInvokers = null;
    private volatile HashLoadBalance<T> hashLoadBalance = null;
    private final Object hashLoadBalanceLock = new Object();
    private volatile ConsistentHashLoadBalance<T> consistentHashLoadBalance = null;
    private final Object consistentHashLoadBalanceLock = new Object();

    public DefaultLoadBalance(ServantProxyConfig config) {
        this.config = config;
        this.roundRobinLoadBalance = new RoundRobinLoadBalance(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invoker<T> select(InvokeContext invocation) throws NoInvokerException {
        long hash = Math.abs(StringUtils.convertLong(invocation.getAttachment("tars_hash"), 0L));
        long consistentHash = Math.abs(StringUtils.convertLong(invocation.getAttachment("taf_consistent_hash"), 0L));
        if (consistentHash > 0L) {
            if (this.consistentHashLoadBalance == null) {
                Object object = this.consistentHashLoadBalanceLock;
                synchronized (object) {
                    if (this.consistentHashLoadBalance == null) {
                        ConsistentHashLoadBalance<T> tmp = new ConsistentHashLoadBalance<T>(this.config);
                        tmp.refresh(this.lastRefreshInvokers);
                        this.consistentHashLoadBalance = tmp;
                    }
                }
            }
            return this.consistentHashLoadBalance.select(invocation);
        }
        if (hash > 0L) {
            if (this.hashLoadBalance == null) {
                Object object = this.hashLoadBalanceLock;
                synchronized (object) {
                    if (this.hashLoadBalance == null) {
                        HashLoadBalance<T> tmp = new HashLoadBalance<T>(this.config);
                        tmp.refresh(this.lastRefreshInvokers);
                        this.hashLoadBalance = tmp;
                    }
                }
            }
            return this.hashLoadBalance.select(invocation);
        }
        return this.roundRobinLoadBalance.select(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Collection<Invoker<T>> invokers) {
        this.lastRefreshInvokers = invokers;
        Object object = this.hashLoadBalanceLock;
        synchronized (object) {
            if (this.hashLoadBalance != null) {
                this.hashLoadBalance.refresh(invokers);
            }
        }
        object = this.consistentHashLoadBalanceLock;
        synchronized (object) {
            if (this.consistentHashLoadBalance != null) {
                this.consistentHashLoadBalance.refresh(invokers);
            }
        }
        this.roundRobinLoadBalance.refresh(invokers);
    }
}

