/*
 * Decompiled with CFR 0.152.
 */
package ninja.amp.ampmenus.menus;

import ninja.amp.ampmenus.MenuListener;
import ninja.amp.ampmenus.events.ItemClickEvent;
import ninja.amp.ampmenus.items.MenuItem;
import ninja.amp.ampmenus.items.StaticMenuItem;
import ninja.amp.ampmenus.menus.MenuHolder;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemMenu {
    private JavaPlugin plugin;
    private String name;
    private Size size;
    private MenuItem[] items;
    private ItemMenu parent;
    private static final MenuItem EMPTY_SLOT_ITEM = new StaticMenuItem(" ", new ItemStack(Material.STAINED_GLASS_PANE, 1, (short)DyeColor.GRAY.getData()), new String[0]);

    public ItemMenu(String name, Size size, JavaPlugin plugin, ItemMenu parent) {
        this.plugin = plugin;
        this.name = name;
        this.size = size;
        this.items = new MenuItem[size.getSize()];
        this.parent = parent;
    }

    public ItemMenu(String name, Size size, JavaPlugin plugin) {
        this(name, size, plugin, null);
    }

    public String getName() {
        return this.name;
    }

    public Size getSize() {
        return this.size;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ItemMenu getParent() {
        return this.parent;
    }

    public void setParent(ItemMenu parent) {
        this.parent = parent;
    }

    public ItemMenu setItem(int position, MenuItem menuItem) {
        this.items[position] = menuItem;
        return this;
    }

    public ItemMenu fillEmptySlots(MenuItem menuItem) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != null) continue;
            this.items[i] = menuItem;
        }
        return this;
    }

    public ItemMenu fillEmptySlots() {
        return this.fillEmptySlots(EMPTY_SLOT_ITEM);
    }

    public void open(Player player) {
        if (!MenuListener.getInstance().isRegistered(this.plugin)) {
            MenuListener.getInstance().register(this.plugin);
        }
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new MenuHolder(this, Bukkit.createInventory((InventoryHolder)player, (int)this.size.getSize())), (int)this.size.getSize(), (String)this.name);
        this.apply(inventory, player);
        player.openInventory(inventory);
    }

    public void update(Player player) {
        Inventory inventory;
        if (player.getOpenInventory() != null && (inventory = player.getOpenInventory().getTopInventory()).getHolder() instanceof MenuHolder && ((MenuHolder)inventory.getHolder()).getMenu().equals(this)) {
            this.apply(inventory, player);
            player.updateInventory();
        }
    }

    private void apply(Inventory inventory, Player player) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            inventory.setItem(i, this.items[i].getFinalIcon(player));
        }
    }

    public void onInventoryClick(InventoryClickEvent event) {
        int slot;
        if (event.getClick() == ClickType.LEFT && (slot = event.getRawSlot()) >= 0 && slot < this.size.getSize() && this.items[slot] != null) {
            Player player = (Player)event.getWhoClicked();
            ItemClickEvent itemClickEvent = new ItemClickEvent(player);
            this.items[slot].onItemClick(itemClickEvent);
            if (itemClickEvent.willUpdate()) {
                this.update(player);
            } else {
                String playerName;
                player.updateInventory();
                if (itemClickEvent.willClose() || itemClickEvent.willGoBack()) {
                    playerName = player.getName();
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Player p = Bukkit.getPlayerExact((String)playerName);
                            if (p != null) {
                                p.closeInventory();
                            }
                        }
                    }, 1L);
                }
                if (itemClickEvent.willGoBack() && this.hasParent()) {
                    playerName = player.getName();
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Player p = Bukkit.getPlayerExact((String)playerName);
                            if (p != null) {
                                ItemMenu.this.parent.open(p);
                            }
                        }
                    }, 3L);
                }
            }
        }
    }

    public void destroy() {
        this.plugin = null;
        this.name = null;
        this.size = null;
        this.items = null;
        this.parent = null;
    }

    public static enum Size {
        ONE_LINE(9),
        TWO_LINE(18),
        THREE_LINE(27),
        FOUR_LINE(36),
        FIVE_LINE(45),
        SIX_LINE(54);

        private final int size;

        private Size(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public static Size fit(int slots) {
            if (slots < 10) {
                return ONE_LINE;
            }
            if (slots < 19) {
                return TWO_LINE;
            }
            if (slots < 28) {
                return THREE_LINE;
            }
            if (slots < 37) {
                return FOUR_LINE;
            }
            if (slots < 46) {
                return FIVE_LINE;
            }
            return SIX_LINE;
        }
    }
}

