/*
 * Decompiled with CFR 0.152.
 */
package ninja.amp.ampmenus.items;

import java.util.Arrays;
import java.util.List;
import ninja.amp.ampmenus.events.ItemClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuItem {
    private final String displayName;
    private final ItemStack icon;
    private final List<String> lore;

    public MenuItem(String displayName, ItemStack icon, String ... lore) {
        this.displayName = displayName;
        this.icon = icon;
        this.lore = Arrays.asList(lore);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ItemStack getFinalIcon(Player player) {
        return MenuItem.setNameAndLore(this.getIcon().clone(), this.getDisplayName(), this.getLore());
    }

    public void onItemClick(ItemClickEvent event) {
    }

    public static ItemStack setNameAndLore(ItemStack itemStack, String displayName, List<String> lore) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(displayName);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        return itemStack;
    }
}

