/*
 * Decompiled with CFR 0.152.
 */
package ninja.amp.ampmenus;

import ninja.amp.ampmenus.menus.MenuHolder;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.java.JavaPlugin;

public class MenuListener
implements Listener {
    private Plugin plugin = null;
    private static final MenuListener INSTANCE = new MenuListener();

    private MenuListener() {
    }

    public static MenuListener getInstance() {
        return INSTANCE;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player && event.getInventory().getHolder() instanceof MenuHolder) {
            event.setCancelled(true);
            ((MenuHolder)event.getInventory().getHolder()).getMenu().onInventoryClick(event);
        }
    }

    public void register(JavaPlugin plugin) {
        if (!this.isRegistered(plugin)) {
            plugin.getServer().getPluginManager().registerEvents((Listener)INSTANCE, (Plugin)plugin);
            this.plugin = plugin;
        }
    }

    public boolean isRegistered(JavaPlugin plugin) {
        if (plugin.equals((Object)this.plugin)) {
            for (RegisteredListener listener : HandlerList.getRegisteredListeners((Plugin)plugin)) {
                if (!listener.getListener().equals(INSTANCE)) continue;
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals(this.plugin)) {
            MenuListener.closeOpenMenus();
            this.plugin = null;
        }
    }

    public static void closeOpenMenus() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Inventory inventory;
            if (player.getOpenInventory() == null || !((inventory = player.getOpenInventory().getTopInventory()).getHolder() instanceof MenuHolder)) continue;
            player.closeInventory();
        }
    }
}

