package com.julienvey.trello.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.julienvey.trello.Trello;

import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TList extends TrelloEntity {

    private String id;
    private String name;
    private List<Card> cards = new ArrayList<>();
    private boolean closed;
    private String idBoard;
    private int pos;
    private boolean subscribed;

    /* API */
    public Card createCard(Card card) {
        return trelloService.createCard(id, card);
    }

    /* Accessors */
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Card> getCards() {
        return cards;
    }

    public void setCards(List<Card> cards) {
        this.cards = cards;
    }

    public boolean isClosed() {
        return closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public String getIdBoard() {
        return idBoard;
    }

    public void setIdBoard(String idBoard) {
        this.idBoard = idBoard;
    }

    public int getPos() {
        return pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public boolean isSubscribed() {
        return subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    @Override
    @SuppressWarnings("unchecked")
    public TList setInternalTrello(Trello trelloService) {
        this.trelloService = trelloService;
        cards.forEach(card -> card.setInternalTrello(trelloService));
        return this;
    }
}
