/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch.operation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.tananaev.jsonpatch.JsonPath;
import com.tananaev.jsonpatch.operation.AbsOperation;
import com.tananaev.jsonpatch.operation.InPlaceElementWrapper;
import java.util.ArrayList;
import java.util.Iterator;

public class AddOperation
extends AbsOperation {
    @SerializedName(value="value")
    public JsonElement data;

    public AddOperation(JsonPath path, JsonElement data) {
        this.data = data;
        this.path = path;
    }

    @Override
    public String getOperationName() {
        return "add";
    }

    @Override
    public void applyInPlace(InPlaceElementWrapper inPlaceElement) {
        JsonElement sourceElement = inPlaceElement.getJsonElement();
        JsonElement item = this.path.head().navigate(sourceElement);
        if (item.isJsonObject()) {
            item.getAsJsonObject().add(this.path.tail(), this.data);
        } else if (item.isJsonArray()) {
            JsonArray array = item.getAsJsonArray();
            int index = this.path.tail().equals("-") ? array.size() : Integer.valueOf(this.path.tail()).intValue();
            ArrayList<JsonElement> temp = new ArrayList<JsonElement>();
            Iterator iter = array.iterator();
            while (iter.hasNext()) {
                JsonElement stuff = (JsonElement)iter.next();
                iter.remove();
                temp.add(stuff);
            }
            temp.add(index, this.data);
            for (JsonElement stuff : temp) {
                array.add(stuff);
            }
        }
    }
}

