/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch;

import com.tananaev.jsonpatch.JsonPatch;
import com.tananaev.jsonpatch.operation.AbsOperation;
import com.tananaev.jsonpatch.operation.MoveOperation;
import com.tananaev.jsonpatch.operation.RemoveOperation;

public class PostProcessor {
    public void process(JsonPatch patch) {
        if (patch.isEmpty()) {
            return;
        }
        AbsOperation operation = (AbsOperation)patch.getLast();
        if (!operation.getOperationName().equals("remove") || PostProcessor.isNumeric(operation.path.tail())) {
            // empty if block
        }
    }

    private void unwindMoves(JsonPatch patch) {
        RemoveOperation removeOperation = (RemoveOperation)patch.removeLast();
        while (!patch.isEmpty()) {
            AbsOperation priorOperation = (AbsOperation)patch.removeLast();
            if (priorOperation.getOperationName().equals("move")) {
                if (priorOperation.path.head().equals(removeOperation.path.head())) {
                    MoveOperation priorMove = (MoveOperation)priorOperation;
                    if (priorMove.path.head().equals(priorMove.from.head())) {
                        try {
                            int removeIndex = Integer.parseInt(removeOperation.path.tail());
                            int moveToIndex = Integer.parseInt(priorMove.path.tail());
                            int moveFromIndex = Integer.parseInt(priorMove.from.tail());
                            if (moveToIndex < moveFromIndex) {
                                if (removeIndex - moveToIndex != 1) continue;
                                removeOperation.path = priorMove.path;
                                continue;
                            }
                            patch.addLast(priorOperation);
                        }
                        catch (NumberFormatException e) {
                            patch.addLast(priorOperation);
                        }
                        break;
                    }
                    patch.addLast(priorOperation);
                    break;
                }
                patch.addLast(priorOperation);
                break;
            }
            patch.addLast(priorOperation);
            break;
        }
        patch.addLast(removeOperation);
    }

    public static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

