/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tananaev.jsonpatch.JsonPatch;
import com.tananaev.jsonpatch.JsonPatchException;
import com.tananaev.jsonpatch.JsonPath;
import com.tananaev.jsonpatch.LongestCommonSubsequenceFactory;
import com.tananaev.jsonpatch.PostProcessor;
import com.tananaev.jsonpatch.operation.AddOperation;
import com.tananaev.jsonpatch.operation.MoveOperation;
import com.tananaev.jsonpatch.operation.RemoveOperation;
import com.tananaev.jsonpatch.operation.ReplaceOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class JsonPatchFactory {
    private LongestCommonSubsequenceFactory lcsf = new LongestCommonSubsequenceFactory();

    public JsonPatch create(JsonElement elementA, JsonElement elementB) {
        JsonPatch patch = new JsonPatch();
        PostProcessor pp = new PostProcessor();
        boolean loop = true;
        while (loop) {
            JsonElement temp = patch.apply(elementA);
            loop = this.processPatch(patch, new JsonPath("/"), temp, elementB);
        }
        return patch;
    }

    private boolean processPatch(JsonPatch patch, JsonPath path, JsonElement elementA, JsonElement elementB) {
        if (elementA == null) {
            patch.add(new ReplaceOperation(path, elementB));
            return true;
        }
        if (elementA.equals(elementB)) {
            return false;
        }
        if (elementA.isJsonArray() && elementB.isJsonArray()) {
            return this.processArrayPatch(patch, path, elementA.getAsJsonArray(), elementB.getAsJsonArray());
        }
        if (elementA.isJsonObject() && elementB.isJsonObject()) {
            return this.processObjectPatch(patch, path, elementA.getAsJsonObject(), elementB.getAsJsonObject());
        }
        patch.add(new ReplaceOperation(path, elementB));
        return true;
    }

    private boolean processObjectPatch(JsonPatch patch, JsonPath path, JsonObject elementA, JsonObject elementB) {
        SortedSet<String> elementAProps = this.extractProps(elementA);
        SortedSet<String> elementBProps = this.extractProps(elementB);
        for (String prop : elementAProps) {
            JsonElement aValue = elementA.get(prop);
            if (elementB.has(prop)) {
                elementBProps.remove(prop);
                JsonElement bValue = elementB.get(prop);
                if (aValue.equals(bValue)) continue;
                return this.processPatch(patch, path.append(prop), aValue, bValue);
            }
            for (String bProp : elementBProps) {
                if (!elementB.get(bProp).equals(aValue)) continue;
                patch.addLast(new MoveOperation(path.append(prop), path.append(bProp)));
                return true;
            }
            patch.addLast(new RemoveOperation(path.append(prop)));
            return true;
        }
        if (elementBProps.size() != 0) {
            String prop = elementBProps.first();
            patch.addLast(new AddOperation(path.append(prop), elementB.get(prop)));
            return true;
        }
        throw new JsonPatchException("theoretically Unreachable");
    }

    private boolean processArrayPatch(JsonPatch patch, JsonPath path, JsonArray elementA, JsonArray elementB) {
        List<JsonElement> listA = this.convertToList(elementA);
        List<JsonElement> listB = this.convertToList(elementB);
        if (listA.isEmpty()) {
            patch.add(new AddOperation(path.append("-"), listB.get(0)));
            return true;
        }
        List<JsonElement> common = this.lcsf.search(listA, listB);
        int startOfCommonInA = this.lcsf.findStartIndex(common, listA);
        int startOfCommonInB = this.lcsf.findStartIndex(common, listB);
        if (listB.size() == common.size()) {
            if (startOfCommonInA != 0) {
                patch.addLast(new RemoveOperation(path.append(0)));
                return true;
            }
            patch.addLast(new RemoveOperation(path.append(startOfCommonInA + common.size())));
            return true;
        }
        if (startOfCommonInB != 0) {
            int targetPos = startOfCommonInB - 1;
            int targetPosA = startOfCommonInA;
            return this.expandCommon(patch, path, listA, listB, common, startOfCommonInA, targetPos, targetPosA);
        }
        int targetPos = startOfCommonInB + common.size();
        int targetPosA = startOfCommonInA + common.size();
        return this.expandCommon(patch, path, listA, listB, common, startOfCommonInA, targetPos, targetPosA);
    }

    private SortedSet<String> extractProps(JsonObject elementA) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry entry : elementA.entrySet()) {
            result.add((String)entry.getKey());
        }
        return result;
    }

    private boolean expandCommon(JsonPatch patch, JsonPath path, List<JsonElement> listA, List<JsonElement> listB, List<JsonElement> common, int startOfCommonInA, int targetPos, int targetPosA) {
        JsonElement target = listB.get(targetPos);
        if (listA.size() > targetPosA && !listB.contains(listA.get(targetPosA))) {
            patch.addLast(new RemoveOperation(path.append(targetPosA)));
            return true;
        }
        for (int occurance : this.findOccurnacesIn(target, listA)) {
            if (occurance >= startOfCommonInA + common.size()) {
                patch.addLast(new MoveOperation(path.append(occurance), path.append(targetPosA)));
                return true;
            }
            if (occurance >= startOfCommonInA) continue;
            int to = targetPosA < occurance ? targetPosA - 1 : targetPosA;
            patch.addLast(new MoveOperation(path.append(occurance), path.append(to >= listA.size() ? "-" : Integer.toString(to))));
            return true;
        }
        patch.addLast(new AddOperation(path.append(targetPosA), target));
        return true;
    }

    private <T> List<Integer> findOccurnacesIn(T item, List<T> list) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int c = 0; c < list.size(); ++c) {
            if (!list.get(c).equals(item)) continue;
            result.add(c);
        }
        return result;
    }

    private List<JsonElement> convertToList(JsonArray array) {
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        for (JsonElement element : array) {
            result.add(element);
        }
        return result;
    }
}

