/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch.operation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.tananaev.jsonpatch.JsonPath;
import com.tananaev.jsonpatch.operation.AbsOperation;

public class ReplaceOperation
extends AbsOperation {
    @SerializedName(value="value")
    public JsonElement data;

    public ReplaceOperation(JsonPath path, JsonElement data) {
        this.path = path;
        this.data = data;
    }

    @Override
    public String getOperationName() {
        return "replace";
    }

    @Override
    public JsonElement apply(JsonElement original) {
        JsonElement result = this.duplicate(original);
        JsonElement item = this.path.head().navigate(result);
        if (item.isJsonObject()) {
            JsonObject object = item.getAsJsonObject();
            object.add(this.path.tail(), this.data);
        } else if (item.isJsonArray()) {
            int index;
            JsonArray array = item.getAsJsonArray();
            int n = index = this.path.tail().equals("-") ? array.size() : Integer.valueOf(this.path.tail()).intValue();
            if (index < array.size()) {
                array.set(index, this.data);
            } else {
                array.add(this.data);
            }
        } else {
            return this.data;
        }
        return result;
    }
}

