/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch.operation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.tananaev.jsonpatch.JsonPath;
import com.tananaev.jsonpatch.operation.AbsOperation;

public class RemoveOperation
extends AbsOperation {
    public RemoveOperation(JsonPath path) {
        this.path = path;
    }

    @Override
    public String getOperationName() {
        return "remove";
    }

    @Override
    public JsonElement apply(JsonElement original) {
        JsonElement result = this.duplicate(original);
        JsonElement item = this.path.head().navigate(result);
        if (item.isJsonObject()) {
            item.getAsJsonObject().remove(this.path.tail());
        } else if (item.isJsonArray()) {
            JsonArray array = item.getAsJsonArray();
            int index = this.path.tail().equals("-") ? array.size() : Integer.valueOf(this.path.tail()).intValue();
            array.remove(index);
        }
        return result;
    }
}

