/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tananaev.jsonpatch.operation.AbsOperation;
import com.tananaev.jsonpatch.operation.AddOperation;
import com.tananaev.jsonpatch.operation.MoveOperation;
import com.tananaev.jsonpatch.operation.RemoveOperation;
import com.tananaev.jsonpatch.operation.ReplaceOperation;
import java.lang.reflect.Type;

public class AbsOperationDeserializer
implements JsonDeserializer<AbsOperation> {
    public AbsOperation deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String operation = element.getAsJsonObject().getAsJsonPrimitive("op").getAsString();
        return (AbsOperation)jsonDeserializationContext.deserialize(element, this.getType(operation));
    }

    private Type getType(String operation) throws JsonSyntaxException {
        if ("add".equals(operation)) {
            return AddOperation.class;
        }
        if ("move".equals(operation)) {
            return MoveOperation.class;
        }
        if ("remove".equals(operation)) {
            return RemoveOperation.class;
        }
        if ("replace".equals(operation)) {
            return ReplaceOperation.class;
        }
        throw new JsonSyntaxException("operation " + operation + " not supported");
    }
}

