/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.jsonpatch;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonPath {
    private List<String> path;

    public JsonPath(String path) {
        this.path = new ArrayList<String>(Arrays.asList(path.split("/")));
        if (this.path.size() > 0) {
            this.path.remove(0);
        }
    }

    private JsonPath(List<String> path) {
        this.path = new ArrayList<String>(path);
    }

    public String toString() {
        if (this.path.size() == 0) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.path) {
            sb.append("/").append(s);
        }
        return sb.toString();
    }

    public String tail() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(this.path.size() - 1);
    }

    public JsonPath head() {
        if (this.path.size() == 0) {
            return this;
        }
        return new JsonPath(this.path.subList(0, this.path.size() - 1));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonPath)) {
            return false;
        }
        if (((JsonPath)obj).path.size() != this.path.size()) {
            return false;
        }
        JsonPath other = (JsonPath)obj;
        boolean result = true;
        for (int c = 0; c < this.path.size(); ++c) {
            result = result && this.path.get(c).equals(other.path.get(c));
        }
        return result;
    }

    public JsonPath append(String path) {
        JsonPath result = new JsonPath(this.path);
        result.path.addAll(Arrays.asList(path.split("/")));
        return result;
    }

    public JsonPath append(int path) {
        return this.append(Integer.toString(path));
    }

    public JsonElement navigate(JsonElement original) {
        for (String segment : this.path) {
            if (original.isJsonObject()) {
                original = original.getAsJsonObject().get(segment);
                continue;
            }
            if (!original.isJsonArray()) continue;
            original = original.getAsJsonArray().get(Integer.parseInt(segment));
        }
        return original;
    }
}

