/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.version;

import com.syntaxphoenix.syntaxapi.version.VersionAnalyzer;
import com.syntaxphoenix.syntaxapi.version.VersionFormatter;

public abstract class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int patch;

    public Version() {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    protected Version setMajor(int major) {
        this.major = major;
        return this;
    }

    protected Version setMinor(int minor) {
        this.minor = minor;
        return this;
    }

    protected Version setPatch(int patch) {
        this.patch = patch;
        return this;
    }

    public boolean isHigher(Version version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major < version.major) {
            return false;
        }
        if (this.minor > version.minor) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        return this.patch > version.patch;
    }

    public boolean isSimilar(Version version) {
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
    }

    public boolean isLower(Version version) {
        if (this.major < version.major) {
            return true;
        }
        if (this.major > version.major) {
            return false;
        }
        if (this.minor < version.minor) {
            return true;
        }
        if (this.minor > version.minor) {
            return false;
        }
        return this.patch < version.patch;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.isSimilar((Version)obj);
        }
        return false;
    }

    public Version clone() {
        return this.init(this.major, this.minor, this.patch);
    }

    public Version update(int major, int minor, int patch) {
        return this.init(this.major + major, this.minor + minor, this.patch + patch);
    }

    protected abstract Version init(int var1, int var2, int var3);

    public abstract VersionAnalyzer getAnalyzer();

    public abstract VersionFormatter getFormatter();

    public String toString() {
        return this.getFormatter().format(this);
    }

    @Override
    public int compareTo(Version version) {
        if (this.isLower(version)) {
            return -1;
        }
        if (this.isHigher(version)) {
            return 1;
        }
        return 0;
    }
}

