/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.reflection;

import com.syntaxphoenix.syntaxapi.reflection.ClassCache;
import com.syntaxphoenix.syntaxapi.reflection.ClasspathAccess;
import java.io.File;
import java.util.HashMap;
import java.util.Optional;

public class PackageAccess {
    public static final Class<?>[] EMPTY = new Class[0];
    protected final HashMap<String, Class<?>> classes = new HashMap();
    protected final ClasspathAccess classpath;
    protected final String packageName;

    public static PackageAccess of(String packageName) {
        return ClasspathAccess.of(packageName).getPackage(packageName);
    }

    PackageAccess(ClasspathAccess classpath, String packageName, File externalPackage) {
        this.classpath = classpath;
        this.packageName = packageName;
        this.scan(externalPackage);
    }

    private void scan(File exteneralPackage) {
        if (exteneralPackage == null) {
            return;
        }
        File[] files = exteneralPackage.listFiles(file -> file.getName().endsWith(".class"));
        for (int index = 0; index < files.length; ++index) {
            String name = files[index].getName().split("\\.")[0];
            Optional<Class<?>> option = ClassCache.getOptionalClass(this.packageName + '.' + name);
            if (!option.isPresent()) continue;
            this.classes.put(name, option.get());
        }
    }

    public ClasspathAccess getClasspath() {
        return this.classpath;
    }

    public boolean hasClasses() {
        return !this.classes.isEmpty();
    }

    public Class<?>[] getClasses() {
        return this.classes.isEmpty() ? EMPTY : this.classes.values().toArray(new Class[0]);
    }

    public Class<?> getClass(String name) {
        return this.classes.get(name);
    }

    public Optional<Class<?>> getOptionalClass(String name) {
        return Optional.ofNullable(this.classes.get(name));
    }
}

