/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.reflection;

import com.syntaxphoenix.syntaxapi.reflection.ClassCache;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ReflectionHelper {
    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return ClassCache.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray;
        if (classLoaders != null && classLoaders.length != 0) {
            return classLoaders;
        }
        ClassLoader contextClassLoader = ReflectionHelper.contextClassLoader();
        ClassLoader staticClassLoader = ReflectionHelper.staticClassLoader();
        if (contextClassLoader != null) {
            if (staticClassLoader != null && contextClassLoader != staticClassLoader) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[2];
                classLoaderArray2[0] = contextClassLoader;
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[1] = staticClassLoader;
            } else {
                ClassLoader[] classLoaderArray3 = new ClassLoader[1];
                classLoaderArray = classLoaderArray3;
                classLoaderArray3[0] = contextClassLoader;
            }
        } else {
            classLoaderArray = new ClassLoader[]{};
        }
        return classLoaderArray;
    }

    public static Collection<URL> forPackage(String name, ClassLoader ... classLoaders) {
        return ReflectionHelper.forResource(ReflectionHelper.resourceName(name), classLoaders);
    }

    public static Collection<URL> forResource(String resourceName, ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        ArrayList<URL> result = new ArrayList<URL>();
        for (ClassLoader classLoader : loaders = ReflectionHelper.classLoaders(classLoaders)) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    int index = url.toExternalForm().lastIndexOf(resourceName);
                    if (index != -1) {
                        result.add(new URL(url, url.toExternalForm().substring(0, index)));
                        continue;
                    }
                    result.add(url);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ReflectionHelper.distinctUrls(result);
    }

    public static URL forClass(Class<?> aClass, ClassLoader ... classLoaders) {
        ClassLoader[] loaders = ReflectionHelper.classLoaders(classLoaders);
        String resourceName = aClass.getName().replace(".", "/") + ".class";
        for (ClassLoader classLoader : loaders) {
            try {
                URL url = classLoader.getResource(resourceName);
                if (url == null) continue;
                String normalizedUrl = url.toExternalForm().substring(0, url.toExternalForm().lastIndexOf(aClass.getPackage().getName().replace(".", "/")));
                return new URL(normalizedUrl);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Collection<URL> forClassLoader() {
        return ReflectionHelper.forClassLoader(ReflectionHelper.classLoaders(new ClassLoader[0]));
    }

    public static Collection<URL> forClassLoader(ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        ArrayList<URL> result = new ArrayList<URL>();
        ClassLoader[] classLoaderArray = loaders = ReflectionHelper.classLoaders(classLoaders);
        int n = classLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            for (ClassLoader classLoader = classLoaderArray[i]; classLoader != null; classLoader = classLoader.getParent()) {
                URL[] urls;
                if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
                result.addAll(Arrays.asList(urls));
            }
        }
        return ReflectionHelper.distinctUrls(result);
    }

    public static Collection<URL> forJavaClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath != null) {
            for (String path : javaClassPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ReflectionHelper.distinctUrls(urls);
    }

    public static Collection<URL> forManifest() {
        return ReflectionHelper.forManifest(ReflectionHelper.forClassLoader());
    }

    public static Collection<URL> forManifest(URL url) {
        ArrayList<URL> result = new ArrayList<URL>();
        result.add(url);
        try {
            String classPath;
            Manifest manifest;
            String part = ReflectionHelper.cleanPath(url);
            File jarFile = new File(part);
            JarFile myJar = new JarFile(part);
            URL validUrl = ReflectionHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), part);
            if (validUrl != null) {
                result.add(validUrl);
            }
            if ((manifest = myJar.getManifest()) != null && (classPath = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"))) != null) {
                for (String jar : classPath.split(" ")) {
                    validUrl = ReflectionHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), jar);
                    if (validUrl == null) continue;
                    result.add(validUrl);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ReflectionHelper.distinctUrls(result);
    }

    public static Collection<URL> forManifest(Iterable<URL> urls) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (URL url : urls) {
            result.addAll(ReflectionHelper.forManifest(url));
        }
        return ReflectionHelper.distinctUrls(result);
    }

    static URL tryToGetValidUrl(String workingDir, String path, String filename) {
        try {
            if (new File(filename).exists()) {
                return new File(filename).toURI().toURL();
            }
            if (new File(path + File.separator + filename).exists()) {
                return new File(path + File.separator + filename).toURI().toURL();
            }
            if (new File(workingDir + File.separator + filename).exists()) {
                return new File(workingDir + File.separator + filename).toURI().toURL();
            }
            if (new File(new URL(filename).getFile()).exists()) {
                return new File(new URL(filename).getFile()).toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static String cleanPath(URL url) {
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (path.startsWith("jar:")) {
            path = path.substring("jar:".length());
        }
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.endsWith("!/")) {
            path = path.substring(0, path.lastIndexOf("!/")) + "/";
        }
        return path;
    }

    private static String resourceName(String name) {
        if (name != null) {
            String resourceName = name.replace(".", "/");
            if ((resourceName = resourceName.replace("\\", "/")).startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            return resourceName;
        }
        return null;
    }

    private static Collection<URL> distinctUrls(Collection<URL> urls) {
        LinkedHashMap<String, URL> distinct = new LinkedHashMap<String, URL>(urls.size());
        for (URL url : urls) {
            distinct.put(url.toExternalForm(), url);
        }
        return distinct.values();
    }
}

