/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.reflection;

import com.syntaxphoenix.syntaxapi.reflection.ClassCache;
import com.syntaxphoenix.syntaxapi.reflection.Reflect;
import com.syntaxphoenix.syntaxapi.reflection.ReflectionTools;
import com.syntaxphoenix.syntaxapi.utils.java.Arrays;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;

public abstract class AbstractReflect {
    public static final AbstractReflect FIELD = new Reflect(Field.class).searchField("modify", "modifiers");
    private final Class<?> owner;
    private final HashMap<String, Constructor<?>> constructors = new HashMap();
    private final HashMap<String, Method> methods = new HashMap();
    private final HashMap<String, Field> fields = new HashMap();

    protected AbstractReflect(String classPath) {
        this.owner = ClassCache.getClass(classPath);
    }

    protected AbstractReflect(Class<?> owner) {
        this.owner = owner;
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    public void delete() {
        this.constructors.clear();
        this.methods.clear();
        this.fields.clear();
        try {
            this.fields.put("owner", this.getClass().getDeclaredField("owner"));
            this.setFieldValue("owner", null);
            this.fields.remove("owner");
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }

    public Collection<Constructor<?>> getConstructors() {
        return this.constructors.values();
    }

    public Collection<Method> getMethods() {
        return this.methods.values();
    }

    public Collection<Field> getFields() {
        return this.fields.values();
    }

    public boolean putConstructor(String name, Constructor<?> constructor) {
        if (this.constructors.containsKey(name)) {
            return false;
        }
        this.constructors.put(name, constructor);
        return true;
    }

    public boolean putMethod(String name, Method method) {
        if (this.methods.containsKey(name)) {
            return false;
        }
        this.methods.put(name, method);
        return true;
    }

    public boolean putField(String name, Field field) {
        if (this.fields.containsKey(name)) {
            return false;
        }
        this.fields.put(name, field);
        return true;
    }

    public boolean containsConstructor(String name) {
        return this.constructors.containsKey(name);
    }

    public boolean containsMethod(String name) {
        return this.methods.containsKey(name);
    }

    public boolean containsField(String name) {
        return this.fields.containsKey(name);
    }

    public Object init() {
        try {
            return this.owner.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object init(String name, Object ... args) {
        Constructor<?> constructor = this.getConstructor(name);
        if (constructor != null) {
            try {
                return constructor.newInstance(args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public AbstractReflect execute(String name, Object ... args) {
        return this.execute((Object)null, name, args);
    }

    public AbstractReflect execute(Object source, String name, Object ... args) {
        this.run(source, name, args);
        return this;
    }

    public Object run(String name, Object ... args) {
        return this.run((Object)null, name, args);
    }

    public Object run(Object source, String name, Object ... args) {
        block5: {
            Method method = this.getMethod(name);
            if (method != null) {
                boolean access = method.isAccessible();
                if (!access) {
                    method.setAccessible(true);
                }
                try {
                    return method.invoke(source, args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    if (!access) {
                        method.setAccessible(access);
                    }
                    e.printStackTrace();
                    if (access) break block5;
                    method.setAccessible(access);
                }
            }
        }
        return null;
    }

    public Object getFieldValue(String name) {
        return this.getFieldValue(name, null);
    }

    public Object getFieldValue(String name, Object source) {
        Field field = this.getField(name);
        if (field != null) {
            boolean access = field.isAccessible();
            if (!access) {
                field.setAccessible(true);
            }
            Object output = null;
            try {
                output = field.get(source);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                if (!access) {
                    field.setAccessible(access);
                }
                e.printStackTrace();
            }
            if (!access) {
                field.setAccessible(access);
            }
            return output;
        }
        return null;
    }

    public void setFieldValue(String name, Object value) {
        this.setFieldValue(null, name, value);
    }

    public void setFieldValue(Object source, String name, Object value) {
        Field field = this.getField(name);
        if (field != null) {
            int previous;
            boolean isFinal;
            boolean access = field.isAccessible();
            if (!access) {
                field.setAccessible(true);
            }
            if (isFinal = Modifier.isFinal(previous = field.getModifiers())) {
                FIELD.setFieldValue(field, "modify", previous & 0xFFFFFFEF);
            }
            try {
                field.set(source, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                if (!access) {
                    field.setAccessible(access);
                }
                if (isFinal) {
                    FIELD.setFieldValue(field, "modify", previous);
                }
                e.printStackTrace();
            }
            if (!access) {
                field.setAccessible(access);
            }
            if (isFinal) {
                FIELD.setFieldValue(field, "modify", previous);
            }
        }
    }

    public Constructor<?> getConstructor(String name) {
        return this.constructors.get(name);
    }

    public Method getMethod(String name) {
        return this.methods.get(name);
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public AbstractReflect searchConstructor(Predicate<AbstractReflect> predicate, String name, Class<?> ... args) {
        return predicate.test(this) ? this.searchConstructor(name, args) : this;
    }

    public AbstractReflect searchConstructor(String name, Class<?> ... arguments) {
        if (this.containsConstructor(name)) {
            return this;
        }
        Constructor<?> constructor = null;
        try {
            constructor = this.owner.getDeclaredConstructor(arguments);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (constructor == null) {
            try {
                constructor = this.owner.getConstructor(arguments);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (constructor != null) {
            this.constructors.put(name, constructor);
        }
        return this;
    }

    public AbstractReflect searchConstructorsByArguments(String base, Class<?> ... arguments) {
        Constructor[] constructors = (Constructor[])Arrays.merge(Constructor[]::new, (Object[])this.owner.getDeclaredConstructors(), (Object[])this.owner.getConstructors());
        if (constructors.length == 0) {
            return this;
        }
        base = base + '-';
        int current = 0;
        for (Constructor constructor : constructors) {
            Class<?>[] args = constructor.getParameterTypes();
            if (args.length != arguments.length || !ReflectionTools.hasSameArguments(arguments, args)) continue;
            this.putConstructor(base + current, constructor);
            ++current;
        }
        return this;
    }

    public AbstractReflect searchMethod(Predicate<AbstractReflect> predicate, String name, String methodName, Class<?> ... arguments) {
        return predicate.test(this) ? this.searchMethod(name, methodName, arguments) : this;
    }

    public AbstractReflect searchMethod(String name, String methodName, Class<?> ... arguments) {
        if (this.containsMethod(name)) {
            return this;
        }
        Method method = null;
        try {
            method = this.owner.getDeclaredMethod(methodName, arguments);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = this.owner.getMethod(methodName, arguments);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (method != null) {
            this.methods.put(name, method);
        }
        return this;
    }

    public AbstractReflect searchMethodsByArguments(String base, Class<?> ... arguments) {
        Method[] methods = (Method[])Arrays.merge(Method[]::new, (Object[])this.owner.getDeclaredMethods(), (Object[])this.owner.getMethods());
        if (methods.length == 0) {
            return this;
        }
        base = base + '-';
        int current = 0;
        for (Method method : methods) {
            Class<?>[] args = method.getParameterTypes();
            if (args.length != arguments.length || !ReflectionTools.hasSameArguments(arguments, args)) continue;
            this.putMethod(base + current, method);
            ++current;
        }
        return this;
    }

    public AbstractReflect searchField(Predicate<AbstractReflect> predicate, String name, String fieldName) {
        return predicate.test(this) ? this.searchField(name, fieldName) : this;
    }

    public AbstractReflect searchField(String name, String fieldName) {
        if (this.containsField(name)) {
            return this;
        }
        Field field = null;
        try {
            field = this.owner.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field == null) {
            try {
                field = this.owner.getField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (field != null) {
            this.fields.put(name, field);
        }
        return this;
    }

    public AbstractReflect searchFields(String name, String fieldName) {
        if (this.containsField(name)) {
            return this;
        }
        Field[] searching = this.owner.getFields();
        int current = 0;
        for (Field field : searching) {
            if (!field.getName().startsWith(fieldName)) continue;
            this.fields.put(name + current, field);
            ++current;
        }
        return this;
    }

    public AbstractReflect searchField(String name, Class<?> type) {
        Field[] searching;
        if (this.containsField(name)) {
            return this;
        }
        for (Field field : searching = this.owner.getFields()) {
            if (field.getType() != type) continue;
            this.fields.put(name, field);
            return this;
        }
        return this;
    }

    public AbstractReflect searchFields(String name, Class<?> type) {
        if (this.containsField(name)) {
            return this;
        }
        Field[] searching = this.owner.getFields();
        int current = 0;
        for (Field field : searching) {
            if (field.getType() != type) continue;
            this.fields.put(name + current, field);
            ++current;
        }
        return this;
    }
}

