/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.tools.NbtOutputStream;
import com.syntaxphoenix.syntaxapi.utils.io.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class NbtSerializer
implements Serializer<NbtNamedTag> {
    public static final NbtSerializer COMPRESSED = new NbtSerializer(true);
    public static final NbtSerializer UNCOMPRESSED = new NbtSerializer(true);
    private final boolean compress;

    public NbtSerializer(boolean compress) {
        this.compress = compress;
    }

    public NbtSerializer() {
        this(true);
    }

    public void toStream(NbtNamedTag tag, OutputStream stream) throws IOException {
        if (this.compress) {
            GZIPOutputStream gzipStream = new GZIPOutputStream(stream);
            NbtOutputStream nbtStream = new NbtOutputStream(gzipStream);
            nbtStream.writeNamedTag(tag);
            gzipStream.finish();
            nbtStream.flush();
            nbtStream.close();
        } else {
            NbtOutputStream output = new NbtOutputStream(stream);
            output.writeNamedTag(tag);
            output.flush();
            output.close();
        }
    }
}

