/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtByteArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtEnd;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtIntArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtLongArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import com.syntaxphoenix.syntaxapi.utils.java.Strings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public final class NbtInputStream
extends DataInputStream {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public NbtInputStream(InputStream in) {
        super(in);
    }

    public NbtNamedTag readNamedTag() throws IOException {
        return this.readNamedTag(0);
    }

    public NbtNamedTag readNamedTag(int depth) throws IOException {
        int id = this.read();
        if (id == -1) {
            return null;
        }
        NbtType type = NbtType.getById((byte)id);
        String name = type != NbtType.END ? this.readString() : "";
        return new NbtNamedTag(name, this.readTag(type, depth));
    }

    public NbtTag readTag(NbtType type, int depth) throws IOException {
        switch (type) {
            case END: {
                return this.readTagEnd(depth);
            }
            case BYTE: {
                return new NbtByte(this.readByte());
            }
            case SHORT: {
                return new NbtShort(this.readShort());
            }
            case INT: {
                return new NbtInt(this.readInt());
            }
            case LONG: {
                return new NbtLong(this.readLong());
            }
            case FLOAT: {
                return new NbtFloat(this.readFloat());
            }
            case DOUBLE: {
                return new NbtDouble(this.readDouble());
            }
            case BYTE_ARRAY: {
                return this.readTagByteArray();
            }
            case STRING: {
                return this.readTagString();
            }
            case LIST: {
                return this.readTagList(depth);
            }
            case COMPOUND: {
                return this.readTagCompound(depth);
            }
            case INT_ARRAY: {
                return this.readTagIntArray();
            }
            case LONG_ARRAY: {
                return this.readTagLongArray();
            }
        }
        throw new IOException("invalid tag type: " + (Object)((Object)type));
    }

    public NbtEnd readTagEnd(int depth) throws IOException {
        if (depth == 0) {
            throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
        }
        return NbtEnd.INSTANCE;
    }

    public NbtByteArray readTagByteArray() throws IOException {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return new NbtByteArray(bytes);
    }

    public NbtString readTagString() throws IOException {
        String input = this.readString();
        if (Strings.isNumeric((String)input)) {
            return new NbtBigInt(input);
        }
        return new NbtString(input);
    }

    public NbtList<?> readTagList(int depth) throws IOException {
        NbtType elementType = NbtType.getById(this.readByte());
        int length = this.readInt();
        if (elementType == NbtType.END && length > 0) {
            throw new IOException("List is of type TAG_End but not empty");
        }
        ArrayList<NbtTag> tagList = new ArrayList<NbtTag>();
        for (int i = 0; i < length; ++i) {
            NbtTag tag = this.readTag(elementType, depth + 1);
            tagList.add(tag);
        }
        return NbtList.createFromTypeAndFill(elementType, tagList);
    }

    public NbtCompound readTagCompound(int depth) throws IOException {
        HashMap<String, NbtTag> tagMap = new HashMap<String, NbtTag>();
        while (true) {
            NbtNamedTag namedTag;
            if ((namedTag = this.readNamedTag(depth + 1)) == null) {
                throw new IOException("NBT ends inside a list");
            }
            NbtTag tag = namedTag.getTag();
            if (tag instanceof NbtEnd) break;
            tagMap.put(namedTag.getName(), tag);
        }
        return new NbtCompound(tagMap);
    }

    public NbtIntArray readTagIntArray() throws IOException {
        int length = this.readInt();
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.readInt();
        }
        return new NbtIntArray(data);
    }

    public NbtLongArray readTagLongArray() throws IOException {
        int length = this.readInt();
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.readLong();
        }
        return new NbtLongArray(data);
    }

    public String readString() throws IOException {
        int length = this.readUnsignedShort();
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return new String(bytes, UTF_8);
    }
}

