/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtBigDecimal;
import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtByteArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtIntArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtLongArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import com.syntaxphoenix.syntaxapi.nbt.tools.MojangsonParseException;
import com.syntaxphoenix.syntaxapi.utils.java.Strings;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class MojangsonParser {
    private static final Pattern DOUBLE_NS = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_S = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final String str;
    private int index;

    public static NbtNamedTag parse(String mson) throws MojangsonParseException {
        return new MojangsonParser(mson).parseRootCompound();
    }

    private MojangsonParser(String str) {
        this.str = str;
    }

    private NbtNamedTag parseRootCompound() throws MojangsonParseException {
        NbtCompound result;
        String name;
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected key");
        }
        if (this.currentChar() == '{') {
            name = "";
            result = this.parseCompound();
        } else {
            name = this.currentChar() == '\"' ? this.parseQuotedString() : this.parseSimpleString();
            this.expectChar(':');
            result = this.parseCompound();
        }
        this.expectNoTrail();
        return new NbtNamedTag(name, result);
    }

    private String parseCompoundKey() throws MojangsonParseException {
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected key");
        }
        return this.currentChar() == '\"' ? this.parseQuotedString() : this.parseSimpleString();
    }

    private NbtTag parseStringOrLiteral() throws MojangsonParseException {
        this.skipWhitespace();
        if (this.currentChar() == '\"') {
            return new NbtString(this.parseQuotedString());
        }
        String str = this.parseSimpleString();
        if (str.isEmpty()) {
            throw this.parseException("Expected value");
        }
        return this.parseLiteral(str);
    }

    private NbtTag parseLiteral(String str) {
        try {
            if (FLOAT.matcher(str).matches()) {
                return new NbtFloat(Float.parseFloat(str.substring(0, str.length() - 1)));
            }
            if (BYTE.matcher(str).matches()) {
                return new NbtByte(Byte.parseByte(str.substring(0, str.length() - 1)));
            }
            if (LONG.matcher(str).matches()) {
                return new NbtLong(Long.parseLong(str.substring(0, str.length() - 1)));
            }
            if (SHORT.matcher(str).matches()) {
                return new NbtShort(Short.parseShort(str.substring(0, str.length() - 1)));
            }
            if (INT.matcher(str).matches()) {
                return new NbtInt(Integer.parseInt(str));
            }
            if (DOUBLE_S.matcher(str).matches()) {
                return new NbtDouble(Double.parseDouble(str.substring(0, str.length() - 1)));
            }
            if (DOUBLE_NS.matcher(str).matches()) {
                return new NbtDouble(Double.parseDouble(str));
            }
            if ("true".equalsIgnoreCase(str)) {
                return new NbtByte(1);
            }
            if ("false".equalsIgnoreCase(str)) {
                return new NbtByte(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Strings.isNumeric((String)str)) {
            return new NbtBigInt(str);
        }
        if (Strings.isDecimal((String)str)) {
            return new NbtBigDecimal(str);
        }
        return new NbtString(str);
    }

    private String parseQuotedString() throws MojangsonParseException {
        int j = ++this.index;
        StringBuilder builder = null;
        boolean escape = false;
        while (this.hasNext()) {
            char c = this.nextChar();
            if (escape) {
                if (c != '\\' && c != '\"') {
                    throw this.parseException("Invalid escape of '" + c + "'");
                }
                escape = false;
            } else {
                if (c == '\\') {
                    escape = true;
                    if (builder != null) continue;
                    builder = new StringBuilder(this.str.substring(j, this.index - 1));
                    continue;
                }
                if (c == '\"') {
                    return builder == null ? this.str.substring(j, this.index - 1) : builder.toString();
                }
            }
            if (builder == null) continue;
            builder.append(c);
        }
        throw this.parseException("Missing termination quote");
    }

    private String parseSimpleString() {
        int j = this.index;
        while (this.hasNext() && MojangsonParser.isSimpleChar(this.currentChar())) {
            ++this.index;
        }
        return this.str.substring(j, this.index);
    }

    private NbtTag parseAnything() throws MojangsonParseException {
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected value");
        }
        char c = this.currentChar();
        if (c == '{') {
            return this.parseCompound();
        }
        if (c == '[') {
            return this.parseDetectedArray();
        }
        return this.parseStringOrLiteral();
    }

    private NbtTag parseDetectedArray() throws MojangsonParseException {
        if (this.hasCharsLeft(2) && this.getChar(1) != '\"' && this.getChar(2) == ';') {
            return this.parseNumArray();
        }
        return this.parseList();
    }

    private NbtCompound parseCompound() throws MojangsonParseException {
        this.expectChar('{');
        NbtCompound compound = new NbtCompound();
        this.skipWhitespace();
        while (this.hasNext() && this.currentChar() != '}') {
            String str = this.parseCompoundKey();
            if (str.isEmpty()) {
                throw this.parseException("Expected non-empty key");
            }
            this.expectChar(':');
            compound.set(str, this.parseAnything());
            if (!this.advanceToNextArrayElement()) break;
            if (this.hasNext()) continue;
            throw this.parseException("Expected key");
        }
        this.expectChar('}');
        return compound;
    }

    private NbtList<?> parseList() throws MojangsonParseException {
        this.expectChar('[');
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected value");
        }
        NbtList<?> list = null;
        NbtType listType = null;
        while (this.currentChar() != ']') {
            NbtTag element = this.parseAnything();
            NbtType elementType = element.getType();
            if (listType == null) {
                listType = elementType;
            } else if (elementType != listType) {
                throw this.parseException("Unable to insert " + (Object)((Object)elementType) + " into ListTag of type " + (Object)((Object)listType));
            }
            if (list == null) {
                list = NbtList.createFromType(elementType);
            }
            list.add(element);
            if (!this.advanceToNextArrayElement()) break;
            if (this.hasNext()) continue;
            throw this.parseException("Expected value");
        }
        this.expectChar(']');
        return list;
    }

    private NbtTag parseNumArray() throws MojangsonParseException {
        this.expectChar('[');
        char arrayType = this.nextChar();
        this.expectChar(';');
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected value");
        }
        if (arrayType == 'B') {
            return new NbtByteArray(this.parseNumArray(NbtType.BYTE_ARRAY, NbtType.BYTE));
        }
        if (arrayType == 'L') {
            return new NbtLongArray(this.parseNumArray(NbtType.LONG_ARRAY, NbtType.LONG));
        }
        if (arrayType == 'I') {
            return new NbtIntArray(this.parseNumArray(NbtType.INT_ARRAY, NbtType.INT));
        }
        throw this.parseException("Invalid array type '" + arrayType + "' found");
    }

    private Number[] parseNumArray(NbtType arrayType, NbtType primType) throws MojangsonParseException {
        ArrayList<Number> result = new ArrayList<Number>();
        while (this.currentChar() != ']') {
            NbtTag element = this.parseAnything();
            NbtType elementType = element.getType();
            if (elementType != primType) {
                throw this.parseException("Unable to insert " + (Object)((Object)elementType) + " into " + (Object)((Object)arrayType));
            }
            if (primType == NbtType.BYTE) {
                result.add(((NbtByte)element).getValue());
            } else if (primType == NbtType.LONG) {
                result.add(((NbtLong)element).getValue());
            } else {
                result.add(((NbtInt)element).getValue());
            }
            if (!this.advanceToNextArrayElement()) break;
            if (this.hasNext()) continue;
            throw this.parseException("Expected value");
        }
        this.expectChar(']');
        return result.toArray(new Number[result.size()]);
    }

    private boolean advanceToNextArrayElement() {
        this.skipWhitespace();
        if (this.hasNext() && this.currentChar() == ',') {
            ++this.index;
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    private void skipWhitespace() {
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.index;
        }
    }

    private boolean hasCharsLeft(int paramInt) {
        return this.index + paramInt < this.str.length();
    }

    private boolean hasNext() {
        return this.hasCharsLeft(0);
    }

    private char getChar(int offset) {
        return this.str.charAt(this.index + offset);
    }

    private char currentChar() {
        return this.getChar(0);
    }

    private char nextChar() {
        return this.str.charAt(this.index++);
    }

    private void expectChar(char c) throws MojangsonParseException {
        this.skipWhitespace();
        boolean hasNext = this.hasNext();
        if (hasNext && this.currentChar() == c) {
            ++this.index;
            return;
        }
        throw new MojangsonParseException("Expected '" + c + "' but got '" + (hasNext ? Character.valueOf(this.currentChar()) : "<EOF>") + "'", this.str, this.index + 1);
    }

    private void expectNoTrail() throws MojangsonParseException {
        this.skipWhitespace();
        if (this.hasNext()) {
            ++this.index;
            throw this.parseException("Trailing data " + this.currentChar() + " found");
        }
    }

    private MojangsonParseException parseException(String paramString) {
        return new MojangsonParseException(paramString, this.str, this.index);
    }

    private static boolean isSimpleChar(char paramChar) {
        return paramChar >= '0' && paramChar <= '9' || paramChar >= 'A' && paramChar <= 'Z' || paramChar >= 'a' && paramChar <= 'z' || paramChar == '_' || paramChar == '-' || paramChar == '.' || paramChar == '+';
    }
}

