/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtByteArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtEnd;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtIntArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtLongArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.reflection.Reflect;

public enum NbtType {
    END("TAG_End", false, false, false, NbtEnd.class),
    BYTE("TAG_Byte", true, true, false, NbtByte.class),
    SHORT("TAG_Short", true, true, false, NbtShort.class),
    INT("TAG_Int", true, true, false, NbtInt.class),
    LONG("TAG_Long", true, true, false, NbtLong.class),
    FLOAT("TAG_Float", true, true, false, NbtFloat.class),
    DOUBLE("TAG_Double", true, true, false, NbtDouble.class),
    BYTE_ARRAY("TAG_Byte_Array", false, false, true, NbtByteArray.class),
    STRING("TAG_String", true, false, false, NbtString.class),
    LIST("TAG_List", false, false, false, NbtList.class),
    COMPOUND("TAG_Compound", false, false, false, NbtCompound.class),
    INT_ARRAY("TAG_Int_Array", false, false, true, NbtIntArray.class),
    LONG_ARRAY("TAG_Long_Array", false, false, true, NbtLongArray.class);

    private final String name;
    private final boolean numeric;
    private final boolean primitive;
    private final boolean array;
    private final byte id;
    private final Reflect owner;

    private NbtType(String name, boolean primitive, boolean numeric, boolean array, Class<? extends NbtTag> owner) {
        this.name = name;
        this.id = (byte)this.ordinal();
        this.numeric = numeric;
        this.primitive = primitive;
        this.array = array;
        this.owner = new Reflect(owner);
    }

    public NbtTag init() {
        return (NbtTag)this.owner.init();
    }

    public static NbtType getById(byte id) {
        return NbtType.values()[id];
    }

    public byte getId() {
        return this.id;
    }

    public static NbtType getByClass(Class<? extends NbtTag> clazz) {
        for (NbtType type : NbtType.values()) {
            if (!type.getOwningClass().equals(clazz)) continue;
            return type;
        }
        return null;
    }

    public Class<? extends NbtTag> getOwningClass() {
        return this.owner.getOwner();
    }

    public Reflect getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.array;
    }
}

