/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtBigDecimal;
import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtByteArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtIntArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtLongArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtNumber;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public final class NbtCompound
extends NbtTag {
    private static final Pattern SIMPLE_STRING = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, NbtTag> value;

    public NbtCompound(Map<String, NbtTag> value) {
        this.value = new LinkedHashMap<String, NbtTag>(value);
    }

    public NbtCompound(NbtNamedTag ... tags) {
        this.value = new LinkedHashMap<String, NbtTag>();
        for (NbtNamedTag tag : tags) {
            this.value.put(tag.getName(), tag.getTag());
        }
    }

    public NbtCompound() {
        this.value = new LinkedHashMap<String, NbtTag>();
    }

    public int size() {
        return this.value.size();
    }

    @Override
    public Map<String, NbtTag> getValue() {
        return this.value;
    }

    @Override
    public NbtType getType() {
        return NbtType.COMPOUND;
    }

    public void clear() {
        this.value.clear();
    }

    @Override
    public NbtCompound clone() {
        return new NbtCompound(this.value);
    }

    public NbtNumber getNumber(String key) {
        if (!this.hasKey(key)) {
            return null;
        }
        NbtTag tag = this.get(key);
        if (!(tag instanceof NbtNumber)) {
            return null;
        }
        return (NbtNumber)((Object)tag);
    }

    public NbtTag remove(String key) {
        if (this.hasKey(key)) {
            return this.value.remove(key);
        }
        return null;
    }

    public NbtTag get(String key) {
        if (!this.hasKey(key)) {
            return null;
        }
        return this.value.get(key);
    }

    public byte getByte(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtByte)) {
            return 0;
        }
        return ((NbtByte)tag).getValue();
    }

    public short getShort(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtShort)) {
            return 0;
        }
        return ((NbtShort)tag).getValue();
    }

    public int getInt(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtInt)) {
            return 0;
        }
        return ((NbtInt)tag).getValue();
    }

    public BigInteger getBigInt(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtBigInt)) {
            return null;
        }
        return ((NbtBigInt)tag).getInteger();
    }

    public long getLong(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtLong)) {
            return 0L;
        }
        return ((NbtLong)tag).getValue();
    }

    public float getFloat(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtFloat)) {
            return 0.0f;
        }
        return ((NbtFloat)tag).getValue().floatValue();
    }

    public double getDouble(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtDouble)) {
            return 0.0;
        }
        return ((NbtDouble)tag).getValue();
    }

    public byte[] getByteArray(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtByteArray)) {
            return null;
        }
        return ((NbtByteArray)tag).getValue();
    }

    public String getString(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtString)) {
            return null;
        }
        return ((NbtString)tag).getValue();
    }

    public List<?> getList(String key) {
        NbtList<?> list = this.getTagList(key);
        if (list == null) {
            return list;
        }
        return list.getValue();
    }

    public NbtList<?> getTagList(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtList)) {
            return null;
        }
        return (NbtList)tag;
    }

    public Map<String, NbtTag> getCompoundMap(String key) {
        return this.getCompound(key).getValue();
    }

    public NbtCompound getCompound(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtCompound)) {
            return null;
        }
        return (NbtCompound)tag;
    }

    public int[] getIntArray(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtIntArray)) {
            return null;
        }
        return ((NbtIntArray)tag).getValue();
    }

    public long[] getLongArray(String key) {
        NbtTag tag = this.value.get(key);
        if (!(tag instanceof NbtLongArray)) {
            return null;
        }
        return ((NbtLongArray)tag).getValue();
    }

    public boolean getBoolean(String path) {
        byte byt = this.getByte(path);
        if (byt == 0 || byt == 1) {
            return byt == 1;
        }
        return false;
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.value.keySet());
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean hasKey(String key) {
        return this.value.containsKey(key);
    }

    public boolean hasKey(String key, NbtType type) {
        Objects.requireNonNull(type);
        return this.value.containsKey(key) && this.value.get(key).getType() == type;
    }

    public boolean hasKeyOfType(String key, NbtType type) {
        return this.hasKey(key, type);
    }

    public void set(String name, NbtTag tag) {
        this.value.put(name, tag);
    }

    public void set(String key, byte[] value) {
        this.set(key, new NbtByteArray(value));
    }

    public void set(String key, byte value) {
        this.set(key, new NbtByte(value));
    }

    public void set(String path, boolean bool) {
        this.set(path, (byte)(bool ? 1 : 0));
    }

    public void set(String key, double value) {
        this.set(key, new NbtDouble(value));
    }

    public void set(String key, float value) {
        this.set(key, new NbtFloat(value));
    }

    public void set(String key, int[] value) {
        this.set(key, new NbtIntArray(value));
    }

    public void set(String key, long[] value) {
        this.set(key, new NbtLongArray(value));
    }

    public void set(String key, int value) {
        this.set(key, new NbtInt(value));
    }

    public void set(String key, BigInteger value) {
        this.set(key, new NbtBigInt(value));
    }

    public void set(String key, BigDecimal value) {
        this.set(key, new NbtBigDecimal(value));
    }

    public void set(String key, long value) {
        this.set(key, new NbtLong(value));
    }

    public void set(String key, short value) {
        this.set(key, new NbtShort(value));
    }

    public void set(String key, String value) {
        this.set(key, new NbtString(value));
    }

    public void forEach(BiConsumer<String, ? super NbtTag> action) {
        this.value.forEach(action::accept);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NbtCompound && this.equals((NbtCompound)obj);
    }

    public boolean equals(NbtCompound tag) {
        return this.isEmpty() && tag.isEmpty() || this.value.equals(tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder builder = new StringBuilder("{");
        Set<String> keys = this.value.keySet();
        for (String key : keys) {
            if (builder.length() > 1) {
                builder.append(',');
            }
            builder.append(SIMPLE_STRING.matcher(key).matches() ? key : NbtString.toMSONString(key)).append(':').append(this.value.get(key).toMSONString());
        }
        return builder.append("}").toString();
    }
}

