/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtBigDecimal;
import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtNumber;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import com.syntaxphoenix.syntaxapi.nbt.tools.MojangsonDeserializer;
import com.syntaxphoenix.syntaxapi.nbt.tools.MojangsonSerializer;
import com.syntaxphoenix.syntaxapi.utils.java.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NbtParser {
    public static final MojangsonDeserializer DESERIALIZER = new MojangsonDeserializer();
    public static final MojangsonSerializer SERIALIZER = new MojangsonSerializer(true);

    public static String toPrettyMson(NbtNamedTag tag) {
        return SERIALIZER.toString(tag);
    }

    public static NbtNamedTag fromPrettyMson(String mson) {
        try {
            return (NbtNamedTag)DESERIALIZER.fromString(mson);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static NbtTag fromObject(Object raw) {
        if (raw instanceof Number) {
            return NbtNumber.fromNumber((Number)raw);
        }
        if (raw instanceof String) {
            String input = (String)raw;
            if (Strings.isNumeric((String)input)) {
                return new NbtBigInt(input);
            }
            if (Strings.isDecimal((String)input)) {
                return new NbtBigDecimal(input);
            }
            return new NbtString(input);
        }
        if (raw instanceof List) {
            List<NbtList<?>> list = NbtParser.fromList((List)raw);
            if (list.size() == 1) {
                return list.get(0);
            }
            return NbtParser.listsToList(list);
        }
        if (raw instanceof Map) {
            return NbtParser.fromMap((Map)raw);
        }
        if (raw instanceof NbtTag) {
            return (NbtTag)raw;
        }
        return null;
    }

    public static List<NbtList<?>> fromList(List<Object> list) {
        ArrayList output = new ArrayList();
        if (list == null || list.isEmpty()) {
            output.add(new NbtList());
            return output;
        }
        HashMap sort = new HashMap();
        for (Object obj : list) {
            NbtTag tag = NbtParser.fromObject(obj);
            NbtType type = tag.getType();
            if (sort.containsKey((Object)type)) {
                ((NbtList)sort.get((Object)type)).add(tag);
                continue;
            }
            NbtList<?> nbt = NbtList.createFromType(type);
            nbt.add(tag);
            sort.put(type, nbt);
        }
        output.addAll(sort.values());
        return output;
    }

    public static NbtCompound fromMap(Map<Object, Object> map) {
        NbtCompound compound = new NbtCompound();
        if (map == null || map.isEmpty()) {
            return compound;
        }
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            Object raw = entry.getKey();
            if (!(raw instanceof String)) continue;
            String key = (String)raw;
            NbtTag input = NbtParser.fromObject(entry.getValue());
            if (input == null) continue;
            compound.set(key, input);
        }
        return compound;
    }

    public static NbtList<NbtList<?>> listsToList(List<NbtList<?>> lists) {
        NbtList list = new NbtList();
        if (lists == null || lists.isEmpty()) {
            return list;
        }
        for (NbtList<?> input : lists) {
            list.add(input);
        }
        return list;
    }
}

