/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtByteArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtIntArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtLongArray;
import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public final class NbtOutputStream
extends DataOutputStream {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int END_ID = NbtType.END.getId();

    public NbtOutputStream(OutputStream out) {
        super(out);
    }

    public void writeNamedTag(String name, NbtTag tag) throws IOException {
        if (tag == null) {
            return;
        }
        byte typeId = tag.getType().getId();
        byte[] nameBytes = name.getBytes(UTF_8);
        this.writeByte(typeId);
        this.writeShort(nameBytes.length);
        this.write(nameBytes);
        if (typeId == END_ID) {
            throw new IOException("Named TAG_End not permitted.");
        }
        this.writeTag(tag);
    }

    public void writeNamedTag(NbtNamedTag tag) throws IOException {
        this.writeNamedTag(tag.getName(), tag.getTag());
    }

    public void writeTag(NbtTag tag) throws IOException {
        switch (tag.getType()) {
            case END: {
                break;
            }
            case BYTE: {
                this.writeByte(((NbtByte)tag).getByteValue());
                break;
            }
            case SHORT: {
                this.writeShort(((NbtShort)tag).getShortValue());
                break;
            }
            case INT: {
                this.writeInt(((NbtInt)tag).getIntValue());
                break;
            }
            case LONG: {
                this.writeLong(((NbtLong)tag).getLongValue());
                break;
            }
            case FLOAT: {
                this.writeFloat(((NbtFloat)tag).getFloatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble(((NbtDouble)tag).getDoubleValue());
                break;
            }
            case BYTE_ARRAY: {
                this.writeTagByteArray((NbtByteArray)tag);
                break;
            }
            case STRING: {
                this.writeTagString((NbtString)tag);
                break;
            }
            case LIST: {
                this.writeTagList((NbtList)tag);
                break;
            }
            case COMPOUND: {
                this.writeTagCompound((NbtCompound)tag);
                break;
            }
            case INT_ARRAY: {
                this.writeTagIntArray((NbtIntArray)tag);
                break;
            }
            case LONG_ARRAY: {
                this.writeTagLongArray((NbtLongArray)tag);
                break;
            }
            default: {
                throw new IOException("invalid tag type: " + (Object)((Object)tag.getType()));
            }
        }
    }

    public void writeTagString(NbtString tag) throws IOException {
        byte[] bytes = tag.getValue().getBytes(UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }

    public void writeTagByteArray(NbtByteArray tag) throws IOException {
        byte[] bytes = tag.getValue();
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    public void writeTagList(NbtList<?> tag) throws IOException {
        NbtType type = tag.getElementType();
        Object tags = tag.getValue();
        int size = tags.size();
        this.writeByte(type.getId());
        this.writeInt(size);
        if (tags.isEmpty()) {
            return;
        }
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            NbtTag element = (NbtTag)iterator.next();
            this.writeTag(element);
        }
    }

    public void writeTagCompound(NbtCompound tag) throws IOException {
        for (Map.Entry entry : tag.getValue().entrySet()) {
            this.writeNamedTag((String)entry.getKey(), (NbtTag)entry.getValue());
        }
        this.writeByte(END_ID);
    }

    public void writeTagIntArray(NbtIntArray tag) throws IOException {
        this.writeInt(tag.length());
        for (int aData : tag.getValue()) {
            this.writeInt(aData);
        }
    }

    public void writeTagLongArray(NbtLongArray tag) throws IOException {
        this.writeInt(tag.length());
        for (long aData : tag.getValue()) {
            this.writeLong(aData);
        }
    }
}

