/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.util.List;
import java.util.Objects;

public class NbtMatcher {
    private static final int EXACT = 1;
    private static final int TYPES_ONLY = 2;
    private final NbtTag pattern;
    private final int flags;

    public NbtMatcher(NbtTag pattern, int flags) {
        this.pattern = Objects.requireNonNull(pattern);
        this.flags = flags;
    }

    public boolean matches(NbtTag tag) {
        return this.pattern.equals(tag);
    }

    private static class NbtMatcherList
    extends NbtTag {
        private final int hash;
        private final byte type;
        private final boolean empty;
        private final NbtTag[] value;

        public NbtMatcherList(NbtList<?> tag) {
            this.empty = tag.isEmpty();
            this.hash = tag.hashCode();
            this.type = tag.getTypeId();
            this.value = tag.getValue().toArray(new NbtTag[tag.size()]);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NbtList && this.equals((NbtList)obj);
        }

        public boolean equals(NbtList<?> tag) {
            return this.empty && tag.isEmpty() || this.type == tag.getTypeId() && this.hash == tag.hashCode() && this.equals(tag.getValue());
        }

        public boolean equals(List<NbtTag> tags) {
            int index = 0;
            for (NbtTag tag : tags) {
                if (tag.equals(this.value[index++])) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public NbtType getType() {
            return NbtType.LIST;
        }

        @Override
        public String toMSONString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NbtMatcherList clone() {
            return new NbtMatcherList(new NbtList(this.value));
        }
    }
}

