/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.tools.NbtInputStream;
import com.syntaxphoenix.syntaxapi.utils.io.Deserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class NbtDeserializer
implements Deserializer<NbtNamedTag> {
    public static final NbtDeserializer COMPRESSED = new NbtDeserializer(true);
    public static final NbtDeserializer UNCOMPRESSED = new NbtDeserializer(false);
    private final boolean compressed;

    public NbtDeserializer(boolean compressed) {
        this.compressed = compressed;
    }

    public NbtDeserializer() {
        this(true);
    }

    public NbtNamedTag fromStream(InputStream stream) throws IOException {
        NbtInputStream nbtStream = this.compressed ? new NbtInputStream(new GZIPInputStream(stream)) : new NbtInputStream(stream);
        NbtNamedTag tag = nbtStream.readNamedTag();
        nbtStream.close();
        if (tag == null) {
            throw new IOException("failed to read NBT tag due to EOS");
        }
        return tag;
    }
}

