/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt.tools;

import com.syntaxphoenix.syntaxapi.nbt.NbtCompound;
import com.syntaxphoenix.syntaxapi.nbt.NbtList;
import com.syntaxphoenix.syntaxapi.nbt.NbtNamedTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class MojangsonWriter
extends Writer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private static final Pattern SIMPLE_STRING = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Writer writer;
    private final boolean pretty;
    private int indent = 0;

    public MojangsonWriter(Writer writer, boolean pretty) {
        this.writer = Objects.requireNonNull(writer);
        this.pretty = pretty;
    }

    public MojangsonWriter(Writer writer) {
        this(writer, false);
    }

    public void writeNamedTag(String name, NbtTag root) throws IOException {
        if (!name.isEmpty()) {
            this.write(new NbtString(name).toMSONString());
            this.write(58);
            if (this.pretty) {
                this.write(32);
            }
        }
        this.writeTag(root);
    }

    public void writeNamedTag(NbtNamedTag nbt) throws IOException {
        this.writeNamedTag(nbt.getName(), nbt.getTag());
    }

    public void writeTag(NbtTag tag) throws IOException {
        if (!this.pretty) {
            this.write(tag.toMSONString());
            return;
        }
        NbtType type = tag.getType();
        if (type == NbtType.END || type.isPrimitive() || type.isArray()) {
            this.writer.write(tag.toMSONString());
        } else if (type == NbtType.COMPOUND) {
            this.writeCompound((NbtCompound)tag);
        } else if (type == NbtType.LIST) {
            this.writeList((NbtList)tag);
        } else {
            throw new AssertionError((Object)type);
        }
    }

    private void writeCompound(NbtCompound compound) throws IOException {
        if (!this.pretty) {
            this.write(compound.toMSONString());
            return;
        }
        this.write(123);
        if (!compound.isEmpty()) {
            boolean simple = MojangsonWriter.isPrimitive(compound);
            if (!simple) {
                ++this.indent;
                this.endLn();
            }
            Object map = compound.getValue();
            Set keys = map.keySet();
            boolean first = true;
            if (simple) {
                for (String key : keys) {
                    if (first) {
                        first = false;
                    } else {
                        this.write(", ");
                    }
                    this.write(SIMPLE_STRING.matcher(key).matches() ? key : NbtString.toMSONString(key));
                    this.write(": ");
                    this.writeTag((NbtTag)map.get(key));
                }
            } else {
                for (String key : keys) {
                    if (first) {
                        first = false;
                    } else {
                        this.write(",");
                        this.endLn();
                    }
                    this.write(SIMPLE_STRING.matcher(key).matches() ? key : NbtString.toMSONString(key));
                    this.write(": ");
                    this.writeTag((NbtTag)map.get(key));
                }
            }
            if (!simple) {
                --this.indent;
                this.endLn();
            }
        }
        this.write(125);
    }

    private void writeList(NbtList<?> list) throws IOException {
        if (!this.pretty) {
            this.write(list.toMSONString());
            return;
        }
        this.write(91);
        if (!list.isEmpty()) {
            boolean simple = MojangsonWriter.isPrimitive(list);
            if (!simple) {
                ++this.indent;
                this.endLn();
            }
            boolean first = true;
            if (simple) {
                for (NbtTag tag : list) {
                    if (first) {
                        first = false;
                    } else {
                        this.write(", ");
                    }
                    this.writeTag(tag);
                }
            } else {
                for (NbtTag tag : list) {
                    if (first) {
                        first = false;
                    } else {
                        this.write(",");
                        this.endLn();
                    }
                    this.writeTag(tag);
                }
            }
            if (!simple) {
                --this.indent;
                this.endLn();
            }
        }
        this.write(93);
    }

    protected void indent() throws IOException {
        if (this.indent == 1) {
            this.writer.write(INDENT);
        } else if (this.indent > 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.append(INDENT);
            }
        }
    }

    protected void endLn() throws IOException {
        this.writer.write(NEWLINE);
        this.indent();
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static boolean isPrimitive(NbtList<?> list) {
        return list.isEmpty() || list.getElementType().isPrimitive();
    }

    private static boolean isPrimitive(NbtCompound compound) {
        if (compound.isEmpty()) {
            return true;
        }
        for (NbtTag val : compound.getValue().values()) {
            if (val.getType().isPrimitive()) continue;
            return false;
        }
        return true;
    }
}

