/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtBigDecimal;
import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtByte;
import com.syntaxphoenix.syntaxapi.nbt.NbtDouble;
import com.syntaxphoenix.syntaxapi.nbt.NbtFloat;
import com.syntaxphoenix.syntaxapi.nbt.NbtInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtLong;
import com.syntaxphoenix.syntaxapi.nbt.NbtShort;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface NbtNumber {
    public Number getValue();

    public void setValue(Number var1);

    default public byte asByte() {
        return this.getValue().byteValue();
    }

    default public short asShort() {
        return this.getValue().shortValue();
    }

    default public int asInt() {
        return this.getValue().intValue();
    }

    default public float asFloat() {
        return this.getValue().floatValue();
    }

    default public long asLong() {
        return this.getValue().longValue();
    }

    default public double asDouble() {
        return this.getValue().doubleValue();
    }

    default public BigInteger asBigInteger() {
        return new BigInteger(this.getValue().toString());
    }

    default public BigDecimal asBigDecimal() {
        return new BigDecimal(this.getValue().toString());
    }

    public static NbtTag fromNumber(Number raw) {
        if (raw instanceof Byte) {
            return new NbtByte(raw.byteValue());
        }
        if (raw instanceof Short) {
            return new NbtShort(raw.shortValue());
        }
        if (raw instanceof Integer) {
            return new NbtInt(raw.intValue());
        }
        if (raw instanceof Float) {
            return new NbtFloat(raw.floatValue());
        }
        if (raw instanceof Long) {
            return new NbtLong(raw.longValue());
        }
        if (raw instanceof Double) {
            return new NbtDouble(raw.doubleValue());
        }
        if (raw instanceof BigInteger) {
            return new NbtBigInt((BigInteger)raw);
        }
        if (raw instanceof BigDecimal) {
            return new NbtBigDecimal((BigDecimal)raw);
        }
        return new NbtInt(raw.intValue());
    }
}

