/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.util.Arrays;

public final class NbtLongArray
extends NbtTag {
    private final long[] value;

    public NbtLongArray(long ... value) {
        this.value = value;
    }

    public NbtLongArray(Number[] numbers) {
        this.value = new long[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.value[i] = numbers[i].longValue();
        }
    }

    public int length() {
        return this.value.length;
    }

    public long[] getValue() {
        return this.value;
    }

    @Override
    public NbtType getType() {
        return NbtType.LONG_ARRAY;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NbtLongArray && this.equals((NbtLongArray)obj);
    }

    public boolean equals(NbtLongArray tag) {
        return Arrays.equals(this.value, tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i]);
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public NbtLongArray clone() {
        return new NbtLongArray((long[])this.value.clone());
    }
}

