/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtAbstractList;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class NbtList<T extends NbtTag>
extends NbtAbstractList<T> {
    private NbtType type;

    private NbtList(NbtType type, List<T> list) {
        this.addAll((Collection<? extends T>)list);
        this.type = type;
    }

    public NbtList(NbtType type) {
        this.type = type;
    }

    public NbtList(List<T> list) {
        if (list != null && !list.isEmpty()) {
            this.addAll((Collection<? extends T>)list);
            this.type = ((NbtTag)list.get(0)).getType();
        }
    }

    public NbtList(T ... array) {
        if (array.length == 0) {
            return;
        }
        this.addAll((Collection<? extends T>)Arrays.asList(array));
        this.type = ((NbtTag)array[0]).getType();
    }

    public NbtList() {
    }

    public boolean addTag(NbtTag element) {
        if (element != null) {
            if (this.type == null) {
                this.type = element.getType();
            } else if (element.getType() != this.type) {
                return false;
            }
        }
        return super.add(element);
    }

    public boolean addTag(int index, NbtTag element) {
        if (element != null) {
            if (this.type == null) {
                this.type = element.getType();
            } else if (element.getType() != this.type) {
                return false;
            }
        }
        super.add(index, element);
        return true;
    }

    @Override
    public boolean add(T element) {
        if (element != null) {
            if (this.type == null) {
                this.type = ((NbtTag)element).getType();
            } else if (((NbtTag)element).getType() != this.type) {
                return false;
            }
        }
        return super.add(element);
    }

    @Override
    public void add(int index, T element) {
        if (element != null) {
            if (this.type == null) {
                this.type = ((NbtTag)element).getType();
            } else if (((NbtTag)element).getType() != this.type) {
                return;
            }
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        int added = 0;
        for (NbtTag tag : collection) {
            if (!this.addTag(tag)) continue;
            ++added;
        }
        return added == collection.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        int added = 0;
        for (NbtTag tag : collection) {
            if (!this.addTag(index, tag)) continue;
            ++added;
            ++index;
        }
        return added == collection.size();
    }

    public void addAllTags(Collection<NbtTag> collection) {
        if (collection.isEmpty()) {
            return;
        }
        for (NbtTag tag : collection) {
            this.addTag(tag);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public NbtType getType() {
        return NbtType.LIST;
    }

    public NbtType getElementType() {
        return this.type != null ? this.type : NbtType.COMPOUND;
    }

    @Override
    public String toMSONString() {
        StringBuilder builder = new StringBuilder("[");
        Iterator iter = this.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(((NbtTag)iter.next()).toMSONString());
        }
        return builder.append("]").toString();
    }

    public static NbtList<?> createFromType(NbtType type) {
        return new NbtList(type);
    }

    public static NbtList<?> createFromTypeAndFill(NbtType type, Collection<? extends NbtTag> values) {
        NbtList<?> list = NbtList.createFromType(type);
        list.addAll((Collection<?>)values);
        return list;
    }

    @Override
    public NbtList<T> clone() {
        if (this.list.isEmpty()) {
            return new NbtList<T>(this.type);
        }
        ArrayList<NbtTag> list = new ArrayList<NbtTag>();
        for (NbtTag tag : this.list) {
            list.add(tag.clone());
        }
        return new NbtList(this.type, list);
    }

    @Override
    public NbtList<T> subList(int fromIndex, int toIndex) {
        return new NbtList(this.type, this.list.subList(fromIndex, toIndex));
    }
}

