/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.util.Arrays;
import java.util.Objects;

public final class NbtIntArray
extends NbtTag
implements Cloneable {
    private final int[] value;

    public NbtIntArray(int[] value) {
        this.value = Objects.requireNonNull(value);
    }

    public NbtIntArray(Number[] numbers) {
        this.value = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.value[i] = numbers[i].intValue();
        }
    }

    public int length() {
        return this.value.length;
    }

    public int[] getValue() {
        return this.value;
    }

    @Override
    public NbtType getType() {
        return NbtType.INT_ARRAY;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NbtIntArray && this.equals((NbtIntArray)obj);
    }

    public boolean equals(NbtIntArray tag) {
        return Arrays.equals(this.value, tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i]);
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public NbtIntArray clone() {
        return new NbtIntArray((int[])this.value.clone());
    }
}

