/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtNumber;
import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;

public final class NbtFloat
extends NbtTag
implements Cloneable,
NbtNumber {
    private float value;

    public NbtFloat() {
        this.value = 0.0f;
    }

    public NbtFloat(float value) {
        this.value = value;
    }

    @Override
    public void setValue(Number number) {
        this.value = number.floatValue();
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public float getFloatValue() {
        return this.value;
    }

    public void setFloatValue(float value) {
        this.value = value;
    }

    @Override
    public NbtType getType() {
        return NbtType.FLOAT;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NbtFloat && this.equals((NbtFloat)obj);
    }

    public boolean equals(NbtFloat tag) {
        return this.value == tag.value;
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Override
    public String toMSONString() {
        return this.value + "f";
    }

    @Override
    public NbtFloat clone() {
        return new NbtFloat(this.value);
    }
}

