/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtTag;
import com.syntaxphoenix.syntaxapi.nbt.NbtType;
import java.util.Arrays;

public final class NbtByteArray
extends NbtTag {
    private final byte[] value;

    public NbtByteArray(byte[] value) {
        this.value = value;
    }

    public NbtByteArray(Number[] numbers) {
        this.value = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.value[i] = numbers[i].byteValue();
        }
    }

    public int length() {
        return this.value.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public NbtType getType() {
        return NbtType.BYTE_ARRAY;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NbtByteArray && this.equals((NbtByteArray)obj);
    }

    public boolean equals(NbtByteArray tag) {
        return Arrays.equals(this.value, tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder stringbuilder = new StringBuilder("[B;");
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i]).append('B');
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public NbtByteArray clone() {
        return new NbtByteArray((byte[])this.value.clone());
    }
}

