/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.utils.java.Strings;
import java.math.BigInteger;

public class NbtBigInt
extends NbtString {
    private BigInteger bigInteger;

    public NbtBigInt() {
    }

    public NbtBigInt(String value) {
        super(Strings.isNumeric((String)value) ? value : "0");
    }

    public NbtBigInt(BigInteger integer) {
        super(integer.toString());
        this.bigInteger = integer;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    public BigInteger getInteger() {
        return this.bigInteger;
    }

    @Override
    public String getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(String value) {
        if (!Strings.isNumeric((String)value)) {
            return;
        }
        this.setValue(new BigInteger(value));
    }

    public void setValue(BigInteger integer) {
        this.bigInteger = integer;
        super.setValue(this.bigInteger.toString());
    }

    @Override
    public NbtString clone() {
        return new NbtBigInt(this.bigInteger.toString());
    }
}

