/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.nbt;

import com.syntaxphoenix.syntaxapi.nbt.NbtBigInt;
import com.syntaxphoenix.syntaxapi.nbt.NbtString;
import com.syntaxphoenix.syntaxapi.utils.java.Strings;
import java.math.BigDecimal;

public class NbtBigDecimal
extends NbtString {
    private BigDecimal bigDecimal;

    public NbtBigDecimal() {
    }

    public NbtBigDecimal(String value) {
        super(Strings.isNumeric((String)value) ? value : "0");
    }

    public NbtBigDecimal(BigDecimal decimal) {
        super(decimal.toString());
        this.bigDecimal = decimal;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    public BigDecimal getDecimal() {
        return this.bigDecimal;
    }

    @Override
    public String getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(String value) {
        if (!Strings.isNumeric((String)value)) {
            return;
        }
        this.setValue(new BigDecimal(value));
    }

    public void setValue(BigDecimal integer) {
        this.bigDecimal = integer;
        super.setValue(this.bigDecimal.toString());
    }

    @Override
    public NbtString clone() {
        return new NbtBigInt(this.bigDecimal.toString());
    }
}

