/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.logging;

import com.syntaxphoenix.syntaxapi.logging.ILogger;
import com.syntaxphoenix.syntaxapi.logging.LogTypeId;
import com.syntaxphoenix.syntaxapi.logging.LoggerState;
import com.syntaxphoenix.syntaxapi.logging.color.ColorTools;
import com.syntaxphoenix.syntaxapi.logging.color.LogType;
import com.syntaxphoenix.syntaxapi.logging.color.LogTypeColor;
import com.syntaxphoenix.syntaxapi.logging.color.LogTypeMap;
import com.syntaxphoenix.syntaxapi.utils.java.Exceptions;
import com.syntaxphoenix.syntaxapi.utils.java.Times;
import java.awt.Color;
import java.io.PrintStream;
import java.util.Optional;
import java.util.function.BiConsumer;

public final class SynLogger
implements ILogger {
    public static final String DEFAULT_FORMAT = "[%date% / %time%][%thread% => %type%] %message%";
    private LogTypeMap typeMap = new LogTypeMap();
    private boolean colored;
    private String format;
    private BiConsumer<Boolean, String> custom;
    private PrintStream stream;
    private LoggerState state = LoggerState.STREAM;
    private String overrideThread;

    public SynLogger() {
        this(System.out);
    }

    public SynLogger(LoggerState state) {
        this(System.out, state);
    }

    public SynLogger(String format) {
        this(System.out, format);
    }

    public SynLogger(PrintStream file) {
        this(file, DEFAULT_FORMAT);
    }

    public SynLogger(String format, LoggerState state) {
        this(System.out, format, state);
    }

    public SynLogger(PrintStream stream, LoggerState state) {
        this(stream, DEFAULT_FORMAT, state);
    }

    public SynLogger(PrintStream stream, String format) {
        this.setColored(true);
        this.setFormat(format);
        this.setStream(stream);
        this.setDefaultTypes();
    }

    public SynLogger(PrintStream stream, String format, LoggerState state) {
        this.setColored(true);
        this.setFormat(format);
        this.setStream(stream);
        this.setState(state);
        this.setDefaultTypes();
    }

    @Override
    public SynLogger close() {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        return this;
    }

    @Override
    public SynLogger setThreadName(String name) {
        this.overrideThread = name;
        return this;
    }

    @Override
    public String getThreadName() {
        if (this.overrideThread == null) {
            return Thread.currentThread().getName();
        }
        String name = this.overrideThread;
        this.overrideThread = null;
        return name;
    }

    @Override
    public SynLogger setCustom(BiConsumer<Boolean, String> custom) {
        this.custom = custom;
        return this;
    }

    @Override
    public BiConsumer<Boolean, String> getCustom() {
        return this.custom;
    }

    @Override
    public SynLogger setState(LoggerState state) {
        this.state = state;
        return this;
    }

    @Override
    public LoggerState getState() {
        return this.state;
    }

    @Override
    public SynLogger setColored(boolean colored) {
        this.colored = colored;
        return this;
    }

    @Override
    public boolean isColored() {
        return this.colored;
    }

    @Override
    public SynLogger setType(LogType type) {
        this.typeMap.override(type);
        return this;
    }

    @Override
    public LogType getType(String typeId) {
        Optional<LogType> option = this.typeMap.tryGetById(typeId);
        return option.isPresent() ? option.get() : LogTypeColor.DEFAULT;
    }

    @Override
    public LogTypeMap getTypeMap() {
        return this.typeMap;
    }

    public SynLogger setStream(PrintStream stream) {
        this.stream = stream;
        return this;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public SynLogger setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public SynLogger setDefaultTypes() {
        this.setType("debug", "#F000FF");
        this.setType("info", "#2FE4E7");
        this.setType("warning", "#E89102");
        this.setType("error", "#FF0000");
        return this;
    }

    public SynLogger setType(String name, String hex) {
        return this.setType(name, ColorTools.hex2rgb(hex));
    }

    public SynLogger setType(String name, Color color) {
        return this.setType(new LogTypeColor(name, color));
    }

    @Override
    public SynLogger log(String message) {
        return this.log(LogTypeId.INFO, message);
    }

    @Override
    public SynLogger log(LogTypeId type, String message) {
        return this.log(type.id(), message);
    }

    @Override
    public SynLogger log(String typeId, String message) {
        return this.log(this.getType(typeId), message);
    }

    public SynLogger log(LogType type, String message) {
        return this.println(type, this.format.replace("%date%", Times.getDate((String)".")).replace("%time%", Times.getTime((String)":")).replace("%thread%", this.getThreadName()).replace("%type%", type.getName()).replace("%message%", message));
    }

    @Override
    public SynLogger log(String ... messages) {
        return this.log(LogTypeId.INFO, messages);
    }

    @Override
    public SynLogger log(LogTypeId type, String ... messages) {
        return this.log(type.id(), messages);
    }

    @Override
    public SynLogger log(String typeId, String ... messages) {
        return this.log(this.getType(typeId), messages);
    }

    public SynLogger log(LogType type, String ... messages) {
        if (messages == null || messages.length == 0) {
            return this;
        }
        String thread = this.getThreadName();
        for (String message : messages) {
            this.setThreadName(thread);
            this.log(type, message);
        }
        return this;
    }

    @Override
    public SynLogger log(Throwable throwable) {
        return this.log(LogTypeId.ERROR, throwable);
    }

    @Override
    public SynLogger log(LogTypeId type, Throwable throwable) {
        return this.log(type.id(), throwable);
    }

    @Override
    public SynLogger log(String typeId, Throwable throwable) {
        return this.log(this.getType(typeId), throwable);
    }

    public SynLogger log(LogType type, Throwable throwable) {
        return this.log(type, Exceptions.stackTraceToStringArray((Throwable)throwable));
    }

    public SynLogger println(LogType type, String message) {
        if (!this.colored) {
            return this.println(message);
        }
        if (this.state.useCustom() && this.custom != null) {
            this.custom.accept(true, type.asColorString(false) + message);
        }
        if (this.state.useStream() && this.stream != null) {
            this.stream.println(type.asColorString(true) + message);
        }
        return this;
    }

    public SynLogger println(String message) {
        if (this.state.useCustom() && this.custom != null) {
            this.custom.accept(true, message);
        }
        if (this.state.useStream() && this.stream != null) {
            this.stream.println(message);
        }
        return this;
    }

    public SynLogger print(LogType type, String message) {
        if (!this.colored) {
            return this.print(message);
        }
        if (this.state.useCustom() && this.custom != null) {
            this.custom.accept(false, type.asColorString(false) + message);
        }
        if (this.state.useStream() && this.stream != null) {
            this.stream.print(type.asColorString(true) + message);
        }
        return this;
    }

    public SynLogger print(String message) {
        if (this.state.useCustom() && this.custom != null) {
            this.custom.accept(false, message);
        }
        if (this.state.useStream() && this.stream != null) {
            this.stream.print(message);
        }
        return this;
    }
}

