/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.config;

import com.syntaxphoenix.syntaxapi.config.ConfigTools;
import com.syntaxphoenix.syntaxapi.config.IBaseSection;
import com.syntaxphoenix.syntaxapi.config.SectionMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseSection
implements IBaseSection {
    protected final SectionMap<String, Object> values = new SectionMap();
    private final String name;

    public BaseSection(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Override
    public Set<String> getKeys() {
        return this.values.keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return !this.name.isEmpty();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(String path) {
        return this.get(path) != null;
    }

    @Override
    public <E> boolean isInstance(String path, E value) {
        Object object = this.get(path);
        return object == null ? false : (value == null ? false : object.getClass().isAssignableFrom(value.getClass()));
    }

    @Override
    public <E> boolean isInstance(String path, Class<E> value) {
        Object object = this.get(path);
        return object == null ? false : (value == null ? false : object.getClass().isAssignableFrom(value));
    }

    @Override
    public <E> E check(String path, E value) {
        Object current = this.get(path);
        if (current != null) {
            return (E)current;
        }
        this.set(path, value);
        return value;
    }

    @Override
    public Object get(String path) {
        if (!path.isEmpty()) {
            return this.get(ConfigTools.getKeys(path));
        }
        return null;
    }

    @Override
    public <E> E get(String path, Class<E> sample) {
        if (!path.isEmpty()) {
            return (E)this.get(ConfigTools.getKeys(path));
        }
        return null;
    }

    @Override
    public <E> E get(String path, E sample) {
        if (!path.isEmpty()) {
            return (E)this.get(ConfigTools.getKeys(path));
        }
        return null;
    }

    private Object get(String[] key) {
        if (key.length != 0 && this.values.containsKey(key[0])) {
            if (key.length > 1) {
                BaseSection section = this.getSection(key[0]);
                if (section != null) {
                    return section.get(ConfigTools.getNextKeys(key));
                }
            } else {
                return this.values.get(key[0]);
            }
        }
        return null;
    }

    @Override
    public BaseSection getSection(String path) {
        if (!path.isEmpty()) {
            return this.getSection(ConfigTools.getKeys(path));
        }
        return null;
    }

    private BaseSection getSection(String[] key) {
        if (key.length != 0 && this.values.containsKey(key[0])) {
            if (key.length > 1) {
                BaseSection section = this.getSection(key[0]);
                if (section != null) {
                    return section.getSection(ConfigTools.getNextKeys(key));
                }
            } else {
                Object uncasted = this.values.get(key[0]);
                if (uncasted instanceof BaseSection) {
                    return (BaseSection)uncasted;
                }
            }
        }
        return null;
    }

    @Override
    public BaseSection createSection(String path) {
        if (!path.isEmpty()) {
            return this.createSection(ConfigTools.getKeys(path));
        }
        return null;
    }

    private BaseSection createSection(String[] key) {
        if (key.length != 0) {
            if (this.values.containsKey(key[0])) {
                if (key.length > 1) {
                    BaseSection section = this.getSection(key[0]);
                    if (section == null) {
                        section = this.saveSection(this.initSection(key[0]));
                    }
                    return section.createSection(ConfigTools.getNextKeys(key));
                }
                Object uncasted = this.get(key[0]);
                if (!(uncasted instanceof BaseSection)) {
                    uncasted = this.saveSection(this.initSection(key[0]));
                }
                return (BaseSection)uncasted;
            }
            BaseSection section = this.saveSection(this.initSection(key[0]));
            if (key.length > 1) {
                return section.createSection(ConfigTools.getNextKeys(key));
            }
            return section;
        }
        return null;
    }

    protected BaseSection saveSection(BaseSection section) {
        this.set(section.getName(), section);
        return section;
    }

    @Override
    public void set(String path, Object value) {
        String[] keys = ConfigTools.getKeys(path);
        String key = ConfigTools.getLastKey(keys);
        this.set(key, ConfigTools.getKeysWithout(keys, key), value);
    }

    @Override
    public void set(String key, String[] path, Object value) {
        if (path.length == 0) {
            this.values.put(key, value);
        } else {
            BaseSection section = this.getSection(path);
            if (section == null) {
                section = this.createSection(path);
            }
            section.set(key, value);
        }
    }

    @Override
    public SectionMap<String, Object> toMap() {
        SectionMap<String, Object> output = new SectionMap<String, Object>();
        if (this.values.isEmpty()) {
            return output;
        }
        Set set = this.values.entrySet();
        for (Map.Entry entry : set) {
            Object out = entry.getValue();
            if (out instanceof BaseSection && this.isSectionInstance((BaseSection)out)) {
                out = ((BaseSection)out).toMap();
            }
            output.put(entry.getKey(), out);
        }
        return output;
    }

    @Override
    public void fromMap(SectionMap<String, Object> input) {
        this.clear();
        Set set = input.entrySet();
        if (set.isEmpty()) {
            return;
        }
        for (Map.Entry entry : set) {
            Object obj = entry.getValue();
            if (obj instanceof SectionMap) {
                this.createSection((String)entry.getKey()).fromMap((SectionMap)obj);
                continue;
            }
            this.set((String)entry.getKey(), obj);
        }
    }

    protected abstract BaseSection initSection(String var1);

    protected abstract boolean isSectionInstance(BaseSection var1);
}

