/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.alias;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Alias {
    private final String name;
    private final List<String> aliases;
    private String displayName;
    private String description;

    public Alias(String name, String ... aliases) {
        this.name = name.toLowerCase();
        this.aliases = Collections.unmodifiableList(Arrays.asList(aliases));
    }

    public String[] getAliases() {
        return this.aliases.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public Alias setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public Alias setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isName(String name) {
        return this.name.equals(name);
    }

    public boolean isAlias(String alias) {
        return this.aliases.contains(alias);
    }

    public boolean isLabel(String label) {
        return this.isName(label = label.toLowerCase()) ? true : this.isAlias(label);
    }

    public boolean hasAliases() {
        return !this.aliases.isEmpty();
    }

    public boolean hasDisplayName() {
        return this.displayName != null && !this.displayName.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Alias removeConflicts(List<String> conflicts) {
        ArrayList<String> list = new ArrayList<String>(this.aliases);
        list.removeAll(conflicts);
        return new Alias(this.name, list.toArray(new String[0])).setDisplayName(this.displayName).setDescription(this.description);
    }

    public static Alias create(String name) {
        return new Alias(name, new String[0]);
    }

    public static Alias create(String name, String ... aliases) {
        return new Alias(name, aliases);
    }
}

