/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.io.plantuml.PlantUMLWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.function.BiConsumer;

public class BasicPlantUMLWriter
extends PlantUMLWriter {
    private String direction;
    private boolean includeNotesForActors = true;

    public BasicPlantUMLWriter() {
        this.addSkinParam("shadowing", "false");
        this.addSkinParam("arrowColor", "#707070");
        this.addSkinParam("actorBorderColor", "#707070");
        this.addSkinParam("componentBorderColor", "#707070");
        this.addSkinParam("rectangleBorderColor", "#707070");
        this.addSkinParam("noteBackgroundColor", "#ffffff");
        this.addSkinParam("noteBorderColor", "#707070");
        this.addSkinParam("defaultTextAlignment", "center");
        this.addSkinParam("wrapWidth", "200");
        this.addSkinParam("maxMessageSize", "100");
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    protected boolean isIncludeNotesForActors() {
        return this.includeNotesForActors;
    }

    public void setIncludeNotesForActors(boolean includeNotesForActors) {
        this.includeNotesForActors = includeNotesForActors;
    }

    @Override
    protected void write(ContainerView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Container)).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            this.writeContainerForSoftwareSystem(view, writer, (writtenView, usedWriter) -> writtenView.getElements().stream().filter(ev -> ev.getElement() instanceof Container).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)writtenView, (Element)e, (Writer)usedWriter, true)));
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void writeContainerForSoftwareSystem(ContainerView view, Writer writer, BiConsumer<ContainerView, Writer> packageContentWriter) throws IOException {
        writer.write("package \"" + view.getSoftwareSystem().getName() + "\" <<" + this.typeOf((View)view, (Element)view.getSoftwareSystem(), false) + ">> {");
        writer.write(System.lineSeparator());
        packageContentWriter.accept(view, writer);
        writer.write("}");
        writer.write(System.lineSeparator());
    }

    @Override
    protected void write(ComponentView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Component)).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)view, (Element)e, writer, false));
            this.writeContainerForContainer(view, writer, (writtenView, usedWriter) -> writtenView.getElements().stream().filter(ev -> ev.getElement() instanceof Component).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((View)writtenView, (Element)e, (Writer)usedWriter, true)));
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    protected void writeContainerForContainer(ComponentView view, Writer writer, BiConsumer<ComponentView, Writer> packageContentWriter) throws IOException {
        writer.write("package \"" + view.getContainer().getName() + "\" <<" + this.typeOf((View)view, (Element)view.getContainer(), false) + ">> {");
        writer.write(System.lineSeparator());
        packageContentWriter.accept(view, writer);
        writer.write("}");
        writer.write(System.lineSeparator());
    }

    @Override
    protected void write(DynamicView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView2 : view.getRelationships()) {
                elements.add(relationshipView2.getRelationship().getSource());
                elements.add(relationshipView2.getRelationship().getDestination());
            }
            if (this.isUseSequenceDiagrams()) {
                elements.forEach(element -> {
                    try {
                        writer.write(String.format("%s \"%s\" as %s <<%s>> %s%s", this.plantumlSequenceType((View)view, (Element)element), element.getName(), this.idOf((Element)element), this.typeOf((View)view, (Element)element, false), this.backgroundOf((View)view, (Element)element), System.lineSeparator()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            } else {
                elements.forEach(e -> this.write((View)view, (Element)e, writer, false));
            }
            view.getRelationships().forEach(relationshipView -> {
                try {
                    Relationship relationship = relationshipView.getRelationship();
                    Element source = relationship.getSource();
                    Element destination = relationship.getDestination();
                    String arrowEnd = ">";
                    if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                        source = relationship.getDestination();
                        destination = relationship.getSource();
                        arrowEnd = "->";
                    }
                    writer.write(String.format("%s -[%s]%s %s : %s. %s", this.idOf(source), view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship).getColor(), arrowEnd, this.idOf(destination), relationshipView.getOrder(), this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationship.getDescription()) ? relationship.getDescription() : "")));
                    writer.write(System.lineSeparator());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.writeFooter(writer);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected void write(View view, DeploymentNode deploymentNode, Writer writer, int indent) {
        try {
            if (view.isElementInView((Element)deploymentNode)) {
                writer.write(String.format("%snode \"%s\" <<%s>> as %s {", this.calculateIndent(indent), deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), this.typeOf(view, (Element)deploymentNode, false), this.idOf((Element)deploymentNode)));
                writer.write(System.lineSeparator());
                ArrayList<DeploymentNode> children = new ArrayList<DeploymentNode>(deploymentNode.getChildren());
                children.sort(Comparator.comparing(Element::getName));
                for (DeploymentNode deploymentNode2 : children) {
                    if (!view.isElementInView((Element)deploymentNode2)) continue;
                    this.write(view, deploymentNode2, writer, indent + 1);
                }
                ArrayList<InfrastructureNode> infrastructureNodes = new ArrayList<InfrastructureNode>(deploymentNode.getInfrastructureNodes());
                infrastructureNodes.sort(Comparator.comparing(Element::getName));
                for (InfrastructureNode infrastructureNode : infrastructureNodes) {
                    if (!view.isElementInView((Element)infrastructureNode)) continue;
                    this.write(view, (Element)infrastructureNode, writer, indent + 1);
                }
                ArrayList<SoftwareSystemInstance> arrayList = new ArrayList<SoftwareSystemInstance>(deploymentNode.getSoftwareSystemInstances());
                arrayList.sort(Comparator.comparing(StaticStructureElementInstance::getName));
                for (SoftwareSystemInstance softwareSystemInstance : arrayList) {
                    if (!view.isElementInView((Element)softwareSystemInstance)) continue;
                    this.write(view, (Element)softwareSystemInstance, writer, indent + 1);
                }
                ArrayList<ContainerInstance> arrayList2 = new ArrayList<ContainerInstance>(deploymentNode.getContainerInstances());
                arrayList2.sort(Comparator.comparing(StaticStructureElementInstance::getName));
                for (ContainerInstance containerInstance : arrayList2) {
                    if (!view.isElementInView((Element)containerInstance)) continue;
                    this.write(view, (Element)containerInstance, writer, indent + 1);
                }
                writer.write(String.format("%s}", this.calculateIndent(indent)));
                writer.write(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void write(View view, Element element, Writer writer, int indent) {
        try {
            String shape = this.plantUMLShapeOf(view, element);
            if ("actor".equals(shape)) {
                this.writeSimpleElement(view, element, writer, indent > 0, shape);
                if (this.includeNotesForActors) {
                    this.writeDescriptionAsNote(element, writer, indent > 0, element.getDescription());
                }
            } else {
                String prefix = this.calculateIndent(indent);
                String separator = System.lineSeparator();
                String id = this.idOf(element);
                String background = this.backgroundOf(view, element);
                String name = element.getName();
                String description = element.getDescription();
                String type = this.typeOf(view, element, false);
                if (element instanceof StaticStructureElementInstance) {
                    StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
                    name = elementInstance.getElement().getName();
                    description = elementInstance.getElement().getDescription();
                    type = this.typeOf(view, (Element)elementInstance.getElement(), false);
                    shape = this.plantUMLShapeOf(view, (Element)elementInstance.getElement());
                    background = this.backgroundOf(view, (Element)elementInstance.getElement());
                }
                writer.write(String.format("%s%s %s <<%s>> %s [%s", prefix, shape, id, type, background, separator));
                writer.write(String.format("%s  %s%s", prefix, name, separator));
                if (!StringUtils.isNullOrEmpty((String)description)) {
                    writer.write(String.format("%s  --%s", prefix, separator));
                    writer.write(String.format("%s  %s%s", prefix, description, separator));
                }
                writer.write(String.format("%s]%s", prefix, separator));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeSimpleElement(View view, Element element, Writer writer, boolean indent, String type) throws IOException {
        writer.write(String.format("%s%s \"%s\" <<%s>> as %s %s%s", indent ? "  " : "", type, element.getName(), this.typeOf(view, element, false), this.idOf(element), this.backgroundOf(view, element), System.lineSeparator()));
    }

    private void writeDescriptionAsNote(Element element, Writer writer, boolean indent, String description) throws IOException {
        if (!StringUtils.isNullOrEmpty((String)description)) {
            String prefix = indent ? "  " : "";
            String separator = System.lineSeparator();
            String id = this.idOf(element);
            writer.write(String.format("%snote right of %s%s", prefix, id, separator));
            writer.write(String.format("%s  %s%s", prefix, description, separator));
            writer.write(String.format("%send note%s", prefix, separator));
        }
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, Writer writer) {
        try {
            Relationship relationship = relationshipView.getRelationship();
            String stereotypeAndDescription = (this.hasValue(relationship.getTechnology()) ? "<<" + relationship.getTechnology() + ">>\\n" : "") + (this.hasValue(relationship.getDescription()) ? relationship.getDescription() : "");
            writer.write(String.format("%s .[%s].> %s %s", this.idOf(relationship.getSource()), view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship).getColor(), this.idOf(relationship.getDestination()), this.hasValue(stereotypeAndDescription) ? ": " + stereotypeAndDescription : ""));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

