/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.SubjectPublicKeyInfo;
import okhttp3.tls.internal.der.Validity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\u0002\u0010\u0015J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tH\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J\u0015\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tH\u00c6\u0003J\t\u00102\u001a\u00020\u000fH\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u008f\u0001\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u00109\u001a\u00020:H\u0016J\t\u0010;\u001a\u00020 H\u00d6\u0001R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006<"}, d2={"Lokhttp3/tls/internal/der/TbsCertificate;", "", "version", "", "serialNumber", "Ljava/math/BigInteger;", "signature", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "issuer", "", "Lokhttp3/tls/internal/der/AttributeTypeAndValue;", "validity", "Lokhttp3/tls/internal/der/Validity;", "subject", "subjectPublicKeyInfo", "Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;", "issuerUniqueID", "Lokhttp3/tls/internal/der/BitString;", "subjectUniqueID", "extensions", "Lokhttp3/tls/internal/der/Extension;", "(JLjava/math/BigInteger;Lokhttp3/tls/internal/der/AlgorithmIdentifier;Ljava/util/List;Lokhttp3/tls/internal/der/Validity;Ljava/util/List;Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;Lokhttp3/tls/internal/der/BitString;Lokhttp3/tls/internal/der/BitString;Ljava/util/List;)V", "getExtensions", "()Ljava/util/List;", "getIssuer", "getIssuerUniqueID", "()Lokhttp3/tls/internal/der/BitString;", "getSerialNumber", "()Ljava/math/BigInteger;", "getSignature", "()Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "signatureAlgorithmName", "", "getSignatureAlgorithmName", "()Ljava/lang/String;", "getSubject", "getSubjectPublicKeyInfo", "()Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;", "getSubjectUniqueID", "getValidity", "()Lokhttp3/tls/internal/der/Validity;", "getVersion", "()J", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "okhttp-tls"})
public final class TbsCertificate {
    private final long version;
    @NotNull
    private final BigInteger serialNumber;
    @NotNull
    private final AlgorithmIdentifier signature;
    @NotNull
    private final List<List<AttributeTypeAndValue>> issuer;
    @NotNull
    private final Validity validity;
    @NotNull
    private final List<List<AttributeTypeAndValue>> subject;
    @NotNull
    private final SubjectPublicKeyInfo subjectPublicKeyInfo;
    @Nullable
    private final BitString issuerUniqueID;
    @Nullable
    private final BitString subjectUniqueID;
    @NotNull
    private final List<Extension> extensions;

    @NotNull
    public final String getSignatureAlgorithmName() {
        String string;
        switch (this.signature.getAlgorithm()) {
            case "1.2.840.113549.1.1.11": {
                string = "SHA256WithRSA";
                break;
            }
            case "1.2.840.10045.4.3.2": {
                string = "SHA256withECDSA";
                break;
            }
            default: {
                String string2 = "unexpected signature algorithm: " + this.signature.getAlgorithm();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return string;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (int)this.version;
        result = 31 * result + this.serialNumber.hashCode();
        result = 31 * result + this.signature.hashCode();
        result = 31 * result + ((Object)this.issuer).hashCode();
        result = 31 * result + this.validity.hashCode();
        result = 31 * result + ((Object)this.subject).hashCode();
        result = 31 * result + this.subjectPublicKeyInfo.hashCode();
        BitString bitString = this.issuerUniqueID;
        result = 31 * result + (bitString != null ? bitString.hashCode() : 0);
        BitString bitString2 = this.subjectUniqueID;
        result = 31 * result + (bitString2 != null ? bitString2.hashCode() : 0);
        result = 31 * result + ((Object)this.extensions).hashCode();
        return result;
    }

    public final long getVersion() {
        return this.version;
    }

    @NotNull
    public final BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public final AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Validity getValidity() {
        return this.validity;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> getSubject() {
        return this.subject;
    }

    @NotNull
    public final SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    @Nullable
    public final BitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    @Nullable
    public final BitString getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    @NotNull
    public final List<Extension> getExtensions() {
        return this.extensions;
    }

    public TbsCertificate(long version, @NotNull BigInteger serialNumber, @NotNull AlgorithmIdentifier signature, @NotNull List<? extends List<AttributeTypeAndValue>> issuer, @NotNull Validity validity2, @NotNull List<? extends List<AttributeTypeAndValue>> subject, @NotNull SubjectPublicKeyInfo subjectPublicKeyInfo2, @Nullable BitString issuerUniqueID, @Nullable BitString subjectUniqueID, @NotNull List<Extension> extensions) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)validity2, (String)"validity");
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.version = version;
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity2;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo2;
        this.issuerUniqueID = issuerUniqueID;
        this.subjectUniqueID = subjectUniqueID;
        this.extensions = extensions;
    }

    public final long component1() {
        return this.version;
    }

    @NotNull
    public final BigInteger component2() {
        return this.serialNumber;
    }

    @NotNull
    public final AlgorithmIdentifier component3() {
        return this.signature;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> component4() {
        return this.issuer;
    }

    @NotNull
    public final Validity component5() {
        return this.validity;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> component6() {
        return this.subject;
    }

    @NotNull
    public final SubjectPublicKeyInfo component7() {
        return this.subjectPublicKeyInfo;
    }

    @Nullable
    public final BitString component8() {
        return this.issuerUniqueID;
    }

    @Nullable
    public final BitString component9() {
        return this.subjectUniqueID;
    }

    @NotNull
    public final List<Extension> component10() {
        return this.extensions;
    }

    @NotNull
    public final TbsCertificate copy(long version, @NotNull BigInteger serialNumber, @NotNull AlgorithmIdentifier signature, @NotNull List<? extends List<AttributeTypeAndValue>> issuer, @NotNull Validity validity2, @NotNull List<? extends List<AttributeTypeAndValue>> subject, @NotNull SubjectPublicKeyInfo subjectPublicKeyInfo2, @Nullable BitString issuerUniqueID, @Nullable BitString subjectUniqueID, @NotNull List<Extension> extensions) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)validity2, (String)"validity");
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        return new TbsCertificate(version, serialNumber, signature, issuer, validity2, subject, subjectPublicKeyInfo2, issuerUniqueID, subjectUniqueID, extensions);
    }

    public static /* synthetic */ TbsCertificate copy$default(TbsCertificate tbsCertificate2, long l, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier2, List list, Validity validity2, List list2, SubjectPublicKeyInfo subjectPublicKeyInfo2, BitString bitString, BitString bitString2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            l = tbsCertificate2.version;
        }
        if ((n & 2) != 0) {
            bigInteger = tbsCertificate2.serialNumber;
        }
        if ((n & 4) != 0) {
            algorithmIdentifier2 = tbsCertificate2.signature;
        }
        if ((n & 8) != 0) {
            list = tbsCertificate2.issuer;
        }
        if ((n & 0x10) != 0) {
            validity2 = tbsCertificate2.validity;
        }
        if ((n & 0x20) != 0) {
            list2 = tbsCertificate2.subject;
        }
        if ((n & 0x40) != 0) {
            subjectPublicKeyInfo2 = tbsCertificate2.subjectPublicKeyInfo;
        }
        if ((n & 0x80) != 0) {
            bitString = tbsCertificate2.issuerUniqueID;
        }
        if ((n & 0x100) != 0) {
            bitString2 = tbsCertificate2.subjectUniqueID;
        }
        if ((n & 0x200) != 0) {
            list3 = tbsCertificate2.extensions;
        }
        return tbsCertificate2.copy(l, bigInteger, algorithmIdentifier2, list, validity2, list2, subjectPublicKeyInfo2, bitString, bitString2, list3);
    }

    @NotNull
    public String toString() {
        return "TbsCertificate(version=" + this.version + ", serialNumber=" + this.serialNumber + ", signature=" + this.signature + ", issuer=" + this.issuer + ", validity=" + this.validity + ", subject=" + this.subject + ", subjectPublicKeyInfo=" + this.subjectPublicKeyInfo + ", issuerUniqueID=" + this.issuerUniqueID + ", subjectUniqueID=" + this.subjectUniqueID + ", extensions=" + this.extensions + ")";
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TbsCertificate)) break block3;
                TbsCertificate tbsCertificate2 = (TbsCertificate)object;
                if (this.version != tbsCertificate2.version || !Intrinsics.areEqual((Object)this.serialNumber, (Object)tbsCertificate2.serialNumber) || !Intrinsics.areEqual((Object)this.signature, (Object)tbsCertificate2.signature) || !Intrinsics.areEqual(this.issuer, tbsCertificate2.issuer) || !Intrinsics.areEqual((Object)this.validity, (Object)tbsCertificate2.validity) || !Intrinsics.areEqual(this.subject, tbsCertificate2.subject) || !Intrinsics.areEqual((Object)this.subjectPublicKeyInfo, (Object)tbsCertificate2.subjectPublicKeyInfo) || !Intrinsics.areEqual((Object)this.issuerUniqueID, (Object)tbsCertificate2.issuerUniqueID) || !Intrinsics.areEqual((Object)this.subjectUniqueID, (Object)tbsCertificate2.subjectUniqueID) || !Intrinsics.areEqual(this.extensions, tbsCertificate2.extensions)) break block3;
            }
            return true;
        }
        return false;
    }
}

