/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.idn;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.idn.IdnaMappingTableKt;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/idn/IdnaMappingTable;", "", "sections", "", "ranges", "mappings", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMappings", "()Ljava/lang/String;", "getRanges", "getSections", "findRangesOffset", "", "codePoint", "position", "limit", "findSectionsIndex", "map", "", "sink", "Lokio/BufferedSink;", "okhttp"})
@SourceDebugExtension(value={"SMAP\nIdnaMappingTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTable\n+ 2 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTableKt\n*L\n1#1,272:1\n258#2,13:273\n258#2,13:286\n*S KotlinDebug\n*F\n+ 1 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTable\n*L\n204#1:273,13\n227#1:286,13\n*E\n"})
public final class IdnaMappingTable {
    @NotNull
    private final String sections;
    @NotNull
    private final String ranges;
    @NotNull
    private final String mappings;

    public IdnaMappingTable(@NotNull String sections, @NotNull String ranges, @NotNull String mappings) {
        Intrinsics.checkNotNullParameter((Object)sections, (String)"sections");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        this.sections = sections;
        this.ranges = ranges;
        this.mappings = mappings;
    }

    @NotNull
    public final String getSections() {
        return this.sections;
    }

    @NotNull
    public final String getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getMappings() {
        return this.mappings;
    }

    public final boolean map(int codePoint, @NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int sectionsIndex = this.findSectionsIndex(codePoint);
        int rangesPosition = IdnaMappingTableKt.read14BitInt(this.sections, sectionsIndex + 2);
        int rangesLimit = sectionsIndex + 4 < this.sections.length() ? IdnaMappingTableKt.read14BitInt(this.sections, sectionsIndex + 6) : this.ranges.length() / 4;
        int rangesIndex = this.findRangesOffset(codePoint, rangesPosition, rangesLimit);
        char b1 = this.ranges.charAt(rangesIndex + 1);
        boolean bl = '\u0000' <= b1 ? b1 < '@' : false;
        if (bl) {
            int beginIndex = IdnaMappingTableKt.read14BitInt(this.ranges, rangesIndex + 2);
            sink.writeUtf8(this.mappings, beginIndex, beginIndex + b1);
        } else {
            boolean bl2 = '@' <= b1 ? b1 < 'P' : false;
            if (bl2) {
                char b2 = this.ranges.charAt(rangesIndex + 2);
                char b3 = this.ranges.charAt(rangesIndex + 3);
                int codepointDelta = (b1 & 0xF) << 14 | b2 << 7 | b3;
                sink.writeUtf8CodePoint(codePoint - codepointDelta);
            } else {
                boolean bl3 = 'P' <= b1 ? b1 < '`' : false;
                if (bl3) {
                    char b2 = this.ranges.charAt(rangesIndex + 2);
                    char b3 = this.ranges.charAt(rangesIndex + 3);
                    int codepointDelta = (b1 & 0xF) << 14 | b2 << 7 | b3;
                    sink.writeUtf8CodePoint(codePoint + codepointDelta);
                } else if (b1 != 'w') {
                    if (b1 == 'x') {
                        sink.writeUtf8CodePoint(codePoint);
                    } else {
                        if (b1 == 'y') {
                            sink.writeUtf8CodePoint(codePoint);
                            return false;
                        }
                        if (b1 == 'z') {
                            sink.writeByte((int)this.ranges.charAt(rangesIndex + 2));
                        } else if (b1 == '{') {
                            sink.writeByte(this.ranges.charAt(rangesIndex + 2) | 0x80);
                        } else if (b1 == '|') {
                            sink.writeByte((int)this.ranges.charAt(rangesIndex + 2));
                            sink.writeByte((int)this.ranges.charAt(rangesIndex + 3));
                        } else if (b1 == '}') {
                            sink.writeByte(this.ranges.charAt(rangesIndex + 2) | 0x80);
                            sink.writeByte((int)this.ranges.charAt(rangesIndex + 3));
                        } else if (b1 == '~') {
                            sink.writeByte((int)this.ranges.charAt(rangesIndex + 2));
                            sink.writeByte(this.ranges.charAt(rangesIndex + 3) | 0x80);
                        } else if (b1 == '\u007f') {
                            sink.writeByte(this.ranges.charAt(rangesIndex + 2) | 0x80);
                            sink.writeByte(this.ranges.charAt(rangesIndex + 3) | 0x80);
                        } else {
                            throw new IllegalStateException(("unexpected rangesIndex for " + codePoint).toString());
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int findSectionsIndex(int codePoint) {
        void v0;
        block3: {
            void limit$iv;
            void position$iv;
            int target = (codePoint & 0x1FFF80) >> 7;
            boolean bl = false;
            int n = this.sections.length() / 4;
            boolean $i$f$binarySearch = false;
            void low$iv = position$iv;
            void high$iv = limit$iv - true;
            while (low$iv <= high$iv) {
                void mid$iv;
                void index = mid$iv = (low$iv + high$iv) / 2;
                boolean bl2 = false;
                void entryIndex = index * 4;
                int b0b1 = IdnaMappingTableKt.read14BitInt(this.sections, (int)entryIndex);
                int compareResult$iv = Intrinsics.compare((int)target, (int)b0b1);
                if (compareResult$iv < 0) {
                    high$iv = mid$iv - true;
                    continue;
                }
                if (compareResult$iv > 0) {
                    low$iv = mid$iv + true;
                    continue;
                }
                v0 = mid$iv;
                break block3;
            }
            v0 = -low$iv - true;
        }
        void offset = v0;
        return (int)(offset >= 0 ? offset * 4 : (-offset - 2) * 4);
    }

    private final int findRangesOffset(int codePoint, int position, int limit) {
        int n;
        block3: {
            int target = codePoint & 0x7F;
            boolean $i$f$binarySearch = false;
            int low$iv = position;
            int high$iv = limit - 1;
            while (low$iv <= high$iv) {
                int mid$iv;
                int index = mid$iv = (low$iv + high$iv) / 2;
                boolean bl = false;
                int entryIndex = index * 4;
                char b0 = this.ranges.charAt(entryIndex);
                int compareResult$iv = Intrinsics.compare((int)target, (int)b0);
                if (compareResult$iv < 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                if (compareResult$iv > 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                n = mid$iv;
                break block3;
            }
            n = -low$iv - 1;
        }
        int offset = n;
        return offset >= 0 ? offset * 4 : (-offset - 2) * 4;
    }
}

