/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.internal.HttpUrlCommon;
import okhttp3.internal._HostnamesCommonKt;
import okhttp3.internal._UtilCommonKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010\u0002\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u0004H\u0007J%\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0000\u00a2\u0006\u0002\b:J%\u0010;\u001a\u00020)2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0000\u00a2\u0006\u0002\b<J%\u0010=\u001a\u00020)2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0000\u00a2\u0006\u0002\b>J\u0012\u0010?\u001a\u00020@*\u00020@2\u0006\u0010A\u001a\u00020\u0004J\u0012\u0010B\u001a\u00020@*\u00020@2\u0006\u0010C\u001a\u00020\u0004J\u001c\u0010D\u001a\u00020@*\u00020@2\u0006\u0010E\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010\u0004J\u0012\u0010G\u001a\u00020@*\u00020@2\u0006\u0010H\u001a\u00020\u0004J\u0012\u0010I\u001a\u00020@*\u00020@2\u0006\u0010J\u001a\u00020\u0004J\u001c\u0010I\u001a\u00020@*\u00020@2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020%H\u0002J\u001c\u0010L\u001a\u00020@*\u00020@2\u0006\u0010M\u001a\u00020\u00042\b\u0010N\u001a\u0004\u0018\u00010\u0004J\n\u0010O\u001a\u00020\u0015*\u00020@J\u0014\u0010\u0014\u001a\u00020@*\u00020@2\b\u0010P\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0018\u001a\u00020@*\u00020@2\u0006\u0010Q\u001a\u00020\u0004J\u0012\u0010\u001a\u001a\u00020@*\u00020@2\u0006\u0010R\u001a\u00020\u0004J\u0014\u0010 \u001a\u00020@*\u00020@2\b\u0010S\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\"\u001a\u00020@*\u00020@2\u0006\u0010T\u001a\u00020\u0004J\u0014\u0010U\u001a\u00020%*\u00020\u00152\b\u0010V\u001a\u0004\u0018\u00010\u0001J\u0014\u0010W\u001a\u00020@*\u00020@2\b\u0010X\u001a\u0004\u0018\u00010\u0004J\n\u0010Y\u001a\u00020)*\u00020\u0015J\u0012\u0010Z\u001a\u00020@*\u00020@2\u0006\u0010[\u001a\u00020\u0004J\n\u0010\\\u001a\u00020@*\u00020\u0015J\u0014\u0010\\\u001a\u0004\u0018\u00010@*\u00020\u00152\u0006\u0010]\u001a\u00020\u0004J#\u0010^\u001a\u00020@*\u00020@2\b\u0010_\u001a\u0004\u0018\u00010\u00152\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b`J\u0012\u0010a\u001a\u00020@*\u00020@2\u0006\u0010b\u001a\u00020\u0004J\u0012\u0010c\u001a\u00020@*\u00020@2\u0006\u0010d\u001a\u00020)J\u0014\u0010,\u001a\u00020@*\u00020@2\b\u0010e\u001a\u0004\u0018\u00010\u0004J\u0014\u0010f\u001a\u0004\u0018\u00010\u0004*\u00020\u00152\u0006\u0010M\u001a\u00020\u0004J\u0012\u0010g\u001a\u00020\u0004*\u00020\u00152\u0006\u0010h\u001a\u00020)J\u0014\u0010i\u001a\u0004\u0018\u00010\u0004*\u00020\u00152\u0006\u0010h\u001a\u00020)J\u001a\u0010j\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001d*\u00020\u00152\u0006\u0010M\u001a\u00020\u0004J\u0011\u0010k\u001a\u00020\u0004*\u00020\u0015H\u0000\u00a2\u0006\u0002\blJ\u0012\u0010m\u001a\u00020n*\u00020@2\u0006\u0010o\u001a\u00020\u0004J\u0012\u0010p\u001a\u00020@*\u00020@2\u0006\u0010E\u001a\u00020\u0004J\u0012\u0010q\u001a\u00020@*\u00020@2\u0006\u0010M\u001a\u00020\u0004J\u0012\u0010r\u001a\u00020@*\u00020@2\u0006\u0010h\u001a\u00020)J\u0014\u0010s\u001a\u0004\u0018\u00010\u0015*\u00020\u00152\u0006\u0010]\u001a\u00020\u0004J\u0012\u0010t\u001a\u00020@*\u00020@2\u0006\u00105\u001a\u00020\u0004J\u001a\u0010u\u001a\u00020@*\u00020@2\u0006\u0010h\u001a\u00020)2\u0006\u0010A\u001a\u00020\u0004J\u001c\u0010v\u001a\u00020@*\u00020@2\u0006\u0010E\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010\u0004J\u001a\u0010w\u001a\u00020@*\u00020@2\u0006\u0010h\u001a\u00020)2\u0006\u0010H\u001a\u00020\u0004J\u001c\u0010x\u001a\u00020@*\u00020@2\u0006\u0010M\u001a\u00020\u00042\b\u0010N\u001a\u0004\u0018\u00010\u0004J\u0011\u0010y\u001a\u00020\u0015*\u00020\u0004H\u0000\u00a2\u0006\u0002\bzJ\u0013\u0010{\u001a\u0004\u0018\u00010\u0015*\u00020\u0004H\u0000\u00a2\u0006\u0002\b|J\n\u0010}\u001a\u00020\u0004*\u00020\u0015J\u0011\u0010}\u001a\u00020\u0004*\u00020@H\u0000\u00a2\u0006\u0002\b~J\u0013\u0010\u007f\u001a\u00020@*\u00020@2\u0007\u0010\u0080\u0001\u001a\u00020\u0004J\u0013\u0010\u0081\u0001\u001a\u00020)*\u00020@H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u001b\u0010\u0083\u0001\u001a\u00020%*\u00020@2\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u001b\u0010\u0085\u0001\u001a\u00020%*\u00020@2\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u0086\u0001J#\u0010\u0087\u0001\u001a\u00020%*\u00020\u00042\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0000\u00a2\u0006\u0003\b\u0088\u0001J2\u0010\u0089\u0001\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u00108\u001a\u00020)2\b\b\u0002\u00109\u001a\u00020)2\t\b\u0002\u0010\u008a\u0001\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0013\u0010\u008c\u0001\u001a\u00020n*\u00020@H\u0000\u00a2\u0006\u0003\b\u008d\u0001J<\u0010\u008e\u0001\u001a\u00020n*\u00020@2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)2\u0007\u0010\u008f\u0001\u001a\u00020%2\u0006\u0010K\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u0090\u0001J,\u0010\u0091\u0001\u001a\u00020n*\u00020@2\u0006\u00107\u001a\u00020\u00042\u0007\u0010\u0092\u0001\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0000\u00a2\u0006\u0003\b\u0093\u0001J#\u0010\u0094\u0001\u001a\u00020)*\u00020\u00042\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0000\u00a2\u0006\u0003\b\u0095\u0001J(\u0010\u0096\u0001\u001a\u00020n*\b\u0012\u0004\u0012\u00020\u00040\u001d2\r\u0010\u0097\u0001\u001a\b0\u0098\u0001j\u0003`\u0099\u0001H\u0000\u00a2\u0006\u0003\b\u009a\u0001J\u001c\u0010\u009b\u0001\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u009c\u0001*\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u009d\u0001J*\u0010\u009e\u0001\u001a\u00020n*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001d2\r\u0010\u0097\u0001\u001a\b0\u0098\u0001j\u0003`\u0099\u0001H\u0000\u00a2\u0006\u0003\b\u009f\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0004*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0018\u001a\u00020\u0004*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0015\u0010\u001a\u001a\u00020\u0004*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u0004\u0018\u00010\u0004*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0015\u0010\"\u001a\u00020\u0004*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0015\u0010$\u001a\u00020%*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0015\u0010(\u001a\u00020)*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\u0004\u0018\u00010\u0004*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0017R\u001b\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0015\u00102\u001a\u00020)*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b3\u0010+\u00a8\u0006\u00a0\u0001"}, d2={"Lokhttp3/internal/CommonHttpUrl;", "", "()V", "FORM_ENCODE_SET", "", "FRAGMENT_ENCODE_SET", "FRAGMENT_ENCODE_SET_URI", "HEX_DIGITS", "", "getHEX_DIGITS$okhttp", "()[C", "INVALID_HOST", "PASSWORD_ENCODE_SET", "PATH_SEGMENT_ENCODE_SET", "PATH_SEGMENT_ENCODE_SET_URI", "QUERY_COMPONENT_ENCODE_SET", "QUERY_COMPONENT_ENCODE_SET_URI", "QUERY_COMPONENT_REENCODE_SET", "QUERY_ENCODE_SET", "USERNAME_ENCODE_SET", "commonEncodedFragment", "Lokhttp3/HttpUrl;", "getCommonEncodedFragment", "(Lokhttp3/HttpUrl;)Ljava/lang/String;", "commonEncodedPassword", "getCommonEncodedPassword", "commonEncodedPath", "getCommonEncodedPath", "commonEncodedPathSegments", "", "getCommonEncodedPathSegments", "(Lokhttp3/HttpUrl;)Ljava/util/List;", "commonEncodedQuery", "getCommonEncodedQuery", "commonEncodedUsername", "getCommonEncodedUsername", "commonIsHttps", "", "getCommonIsHttps", "(Lokhttp3/HttpUrl;)Z", "commonPathSize", "", "getCommonPathSize", "(Lokhttp3/HttpUrl;)I", "commonQuery", "getCommonQuery", "commonQueryParameterNames", "", "getCommonQueryParameterNames", "(Lokhttp3/HttpUrl;)Ljava/util/Set;", "commonQuerySize", "getCommonQuerySize", "commonDefaultPort", "scheme", "parsePort", "input", "pos", "limit", "parsePort$okhttp", "portColonOffset", "portColonOffset$okhttp", "schemeDelimiterOffset", "schemeDelimiterOffset$okhttp", "commonAddEncodedPathSegment", "Lokhttp3/HttpUrl$Builder;", "encodedPathSegment", "commonAddEncodedPathSegments", "encodedPathSegments", "commonAddEncodedQueryParameter", "encodedName", "encodedValue", "commonAddPathSegment", "pathSegment", "commonAddPathSegments", "pathSegments", "alreadyEncoded", "commonAddQueryParameter", "name", "value", "commonBuild", "encodedFragment", "encodedPassword", "encodedPath", "encodedQuery", "encodedUsername", "commonEquals", "other", "commonFragment", "fragment", "commonHashCode", "commonHost", "host", "commonNewBuilder", "link", "commonParse", "base", "commonParse$okhttp", "commonPassword", "password", "commonPort", "port", "query", "commonQueryParameter", "commonQueryParameterName", "index", "commonQueryParameterValue", "commonQueryParameterValues", "commonRedact", "commonRedact$okhttp", "commonRemoveAllCanonicalQueryParameters", "", "canonicalName", "commonRemoveAllEncodedQueryParameters", "commonRemoveAllQueryParameters", "commonRemovePathSegment", "commonResolve", "commonScheme", "commonSetEncodedPathSegment", "commonSetEncodedQueryParameter", "commonSetPathSegment", "commonSetQueryParameter", "commonToHttpUrl", "commonToHttpUrl$okhttp", "commonToHttpUrlOrNull", "commonToHttpUrlOrNull$okhttp", "commonToString", "commonToString$okhttp", "commonUsername", "username", "effectivePort", "effectivePort$okhttp", "isDot", "isDot$okhttp", "isDotDot", "isDotDot$okhttp", "isPercentEncoded", "isPercentEncoded$okhttp", "percentDecode", "plusIsSpace", "percentDecode$okhttp", "pop", "pop$okhttp", "push", "addTrailingSlash", "push$okhttp", "resolvePath", "startPos", "resolvePath$okhttp", "slashCount", "slashCount$okhttp", "toPathString", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toPathString$okhttp", "toQueryNamesAndValues", "", "toQueryNamesAndValues$okhttp", "toQueryString", "toQueryString$okhttp", "okhttp"})
@SourceDebugExtension(value={"SMAP\n-HttpUrlCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -HttpUrlCommon.kt\nokhttp3/internal/CommonHttpUrl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,905:1\n1#2:906\n1549#3:907\n1620#3,3:908\n1549#3:911\n1620#3,3:912\n*S KotlinDebug\n*F\n+ 1 -HttpUrlCommon.kt\nokhttp3/internal/CommonHttpUrl\n*L\n597#1:907\n597#1:908,3\n598#1:911\n598#1:912,3\n*E\n"})
public final class CommonHttpUrl {
    @NotNull
    public static final CommonHttpUrl INSTANCE = new CommonHttpUrl();
    @NotNull
    private static final char[] HEX_DIGITS;
    @NotNull
    private static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    @NotNull
    private static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    @NotNull
    private static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    @NotNull
    public static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    @NotNull
    private static final String QUERY_ENCODE_SET = " \"'<>#";
    @NotNull
    private static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    @NotNull
    private static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    @NotNull
    public static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    @NotNull
    public static final String FORM_ENCODE_SET = " !\"#$&'()+,/:;<=>?@[\\]^`{|}~";
    @NotNull
    private static final String FRAGMENT_ENCODE_SET = "";
    @NotNull
    public static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    @NotNull
    public static final String INVALID_HOST = "Invalid URL host";

    private CommonHttpUrl() {
    }

    @NotNull
    public final char[] getHEX_DIGITS$okhttp() {
        return HEX_DIGITS;
    }

    public final boolean getCommonIsHttps(@NotNull HttpUrl $this$commonIsHttps) {
        Intrinsics.checkNotNullParameter((Object)$this$commonIsHttps, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$commonIsHttps.scheme(), (Object)"https");
    }

    @NotNull
    public final String getCommonEncodedUsername(@NotNull HttpUrl $this$commonEncodedUsername) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedUsername, (String)"<this>");
        if (((CharSequence)$this$commonEncodedUsername.username()).length() == 0) {
            return FRAGMENT_ENCODE_SET;
        }
        int usernameStart = $this$commonEncodedUsername.scheme().length() + 3;
        int usernameEnd = _UtilCommonKt.delimiterOffset($this$commonEncodedUsername.getUrl$okhttp(), ":@", usernameStart, $this$commonEncodedUsername.getUrl$okhttp().length());
        String string = $this$commonEncodedUsername.getUrl$okhttp().substring(usernameStart, usernameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final String getCommonEncodedPassword(@NotNull HttpUrl $this$commonEncodedPassword) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedPassword, (String)"<this>");
        if (((CharSequence)$this$commonEncodedPassword.password()).length() == 0) {
            return FRAGMENT_ENCODE_SET;
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)$this$commonEncodedPassword.getUrl$okhttp(), (char)':', (int)($this$commonEncodedPassword.scheme().length() + 3), (boolean)false, (int)4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)$this$commonEncodedPassword.getUrl$okhttp(), (char)'@', (int)0, (boolean)false, (int)6, null);
        String string = $this$commonEncodedPassword.getUrl$okhttp().substring(passwordStart, passwordEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public final int getCommonPathSize(@NotNull HttpUrl $this$commonPathSize) {
        Intrinsics.checkNotNullParameter((Object)$this$commonPathSize, (String)"<this>");
        return $this$commonPathSize.pathSegments().size();
    }

    @NotNull
    public final String getCommonEncodedPath(@NotNull HttpUrl $this$commonEncodedPath) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedPath, (String)"<this>");
        int pathStart = StringsKt.indexOf$default((CharSequence)$this$commonEncodedPath.getUrl$okhttp(), (char)'/', (int)($this$commonEncodedPath.scheme().length() + 3), (boolean)false, (int)4, null);
        int pathEnd = _UtilCommonKt.delimiterOffset($this$commonEncodedPath.getUrl$okhttp(), "?#", pathStart, $this$commonEncodedPath.getUrl$okhttp().length());
        String string = $this$commonEncodedPath.getUrl$okhttp().substring(pathStart, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final List<String> getCommonEncodedPathSegments(@NotNull HttpUrl $this$commonEncodedPathSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedPathSegments, (String)"<this>");
        int pathStart = StringsKt.indexOf$default((CharSequence)$this$commonEncodedPathSegments.getUrl$okhttp(), (char)'/', (int)($this$commonEncodedPathSegments.scheme().length() + 3), (boolean)false, (int)4, null);
        int pathEnd = _UtilCommonKt.delimiterOffset($this$commonEncodedPathSegments.getUrl$okhttp(), "?#", pathStart, $this$commonEncodedPathSegments.getUrl$okhttp().length());
        List result = new ArrayList();
        int i = pathStart;
        while (i < pathEnd) {
            int segmentEnd = _UtilCommonKt.delimiterOffset($this$commonEncodedPathSegments.getUrl$okhttp(), '/', ++i, pathEnd);
            String string = $this$commonEncodedPathSegments.getUrl$okhttp().substring(i, segmentEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(string);
            i = segmentEnd;
        }
        return result;
    }

    @Nullable
    public final String getCommonEncodedQuery(@NotNull HttpUrl $this$commonEncodedQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedQuery, (String)"<this>");
        if ($this$commonEncodedQuery.getQueryNamesAndValues$okhttp() == null) {
            return null;
        }
        int queryStart = StringsKt.indexOf$default((CharSequence)$this$commonEncodedQuery.getUrl$okhttp(), (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        int queryEnd = _UtilCommonKt.delimiterOffset($this$commonEncodedQuery.getUrl$okhttp(), '#', queryStart, $this$commonEncodedQuery.getUrl$okhttp().length());
        String string = $this$commonEncodedQuery.getUrl$okhttp().substring(queryStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Nullable
    public final String getCommonQuery(@NotNull HttpUrl $this$commonQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQuery, (String)"<this>");
        if ($this$commonQuery.getQueryNamesAndValues$okhttp() == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        this.toQueryString$okhttp($this$commonQuery.getQueryNamesAndValues$okhttp(), result);
        return result.toString();
    }

    public final int getCommonQuerySize(@NotNull HttpUrl $this$commonQuerySize) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQuerySize, (String)"<this>");
        return $this$commonQuerySize.getQueryNamesAndValues$okhttp() != null ? $this$commonQuerySize.getQueryNamesAndValues$okhttp().size() / 2 : 0;
    }

    @Nullable
    public final String commonQueryParameter(@NotNull HttpUrl $this$commonQueryParameter, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if ($this$commonQueryParameter.getQueryNamesAndValues$okhttp() == null) {
            return null;
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$commonQueryParameter.getQueryNamesAndValues$okhttp().size())), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                if (Intrinsics.areEqual((Object)name, (Object)$this$commonQueryParameter.getQueryNamesAndValues$okhttp().get(i))) {
                    return $this$commonQueryParameter.getQueryNamesAndValues$okhttp().get(i + 1);
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    @NotNull
    public final Set<String> getCommonQueryParameterNames(@NotNull HttpUrl $this$commonQueryParameterNames) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQueryParameterNames, (String)"<this>");
        if ($this$commonQueryParameterNames.getQueryNamesAndValues$okhttp() == null) {
            return SetsKt.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$commonQueryParameterNames.getQueryNamesAndValues$okhttp().size())), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                String string = $this$commonQueryParameterNames.getQueryNamesAndValues$okhttp().get(i);
                Intrinsics.checkNotNull((Object)string);
                result.add(string);
                if (i == n) break;
                i += n2;
            }
        }
        return _UtilCommonKt.readOnly((Set)result);
    }

    @NotNull
    public final List<String> commonQueryParameterValues(@NotNull HttpUrl $this$commonQueryParameterValues, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQueryParameterValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if ($this$commonQueryParameterValues.getQueryNamesAndValues$okhttp() == null) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$commonQueryParameterValues.getQueryNamesAndValues$okhttp().size())), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                if (Intrinsics.areEqual((Object)name, (Object)$this$commonQueryParameterValues.getQueryNamesAndValues$okhttp().get(i))) {
                    result.add($this$commonQueryParameterValues.getQueryNamesAndValues$okhttp().get(i + 1));
                }
                if (i == n) break;
                i += n2;
            }
        }
        return _UtilCommonKt.readOnly(result);
    }

    @NotNull
    public final String commonQueryParameterName(@NotNull HttpUrl $this$commonQueryParameterName, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQueryParameterName, (String)"<this>");
        if ($this$commonQueryParameterName.getQueryNamesAndValues$okhttp() == null) {
            throw new IndexOutOfBoundsException();
        }
        String string = $this$commonQueryParameterName.getQueryNamesAndValues$okhttp().get(index * 2);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final String commonQueryParameterValue(@NotNull HttpUrl $this$commonQueryParameterValue, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$commonQueryParameterValue, (String)"<this>");
        if ($this$commonQueryParameterValue.getQueryNamesAndValues$okhttp() == null) {
            throw new IndexOutOfBoundsException();
        }
        return $this$commonQueryParameterValue.getQueryNamesAndValues$okhttp().get(index * 2 + 1);
    }

    @Nullable
    public final String getCommonEncodedFragment(@NotNull HttpUrl $this$commonEncodedFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedFragment, (String)"<this>");
        if ($this$commonEncodedFragment.fragment() == null) {
            return null;
        }
        int fragmentStart = StringsKt.indexOf$default((CharSequence)$this$commonEncodedFragment.getUrl$okhttp(), (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
        String string = $this$commonEncodedFragment.getUrl$okhttp().substring(fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public final void toQueryString$okhttp(@NotNull List<String> $this$toQueryString, @NotNull StringBuilder out) {
        Intrinsics.checkNotNullParameter($this$toQueryString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$toQueryString.size())), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                String name = $this$toQueryString.get(i);
                String value = $this$toQueryString.get(i + 1);
                if (i > 0) {
                    out.append('&');
                }
                out.append(name);
                if (value != null) {
                    out.append('=');
                    out.append(value);
                }
                if (i == n) break;
                i += n2;
            }
        }
    }

    @NotNull
    public final String commonRedact$okhttp(@NotNull HttpUrl $this$commonRedact) {
        Intrinsics.checkNotNullParameter((Object)$this$commonRedact, (String)"<this>");
        HttpUrl.Builder builder = $this$commonRedact.newBuilder("/...");
        Intrinsics.checkNotNull((Object)builder);
        return builder.username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public final HttpUrl commonResolve(@NotNull HttpUrl $this$commonResolve, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)$this$commonResolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        HttpUrl.Builder builder = $this$commonResolve.newBuilder(link);
        return builder != null ? builder.build() : null;
    }

    @NotNull
    public final HttpUrl.Builder commonNewBuilder(@NotNull HttpUrl $this$commonNewBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$commonNewBuilder, (String)"<this>");
        HttpUrl.Builder result = new HttpUrl.Builder();
        result.setScheme$okhttp($this$commonNewBuilder.scheme());
        result.setEncodedUsername$okhttp($this$commonNewBuilder.encodedUsername());
        result.setEncodedPassword$okhttp($this$commonNewBuilder.encodedPassword());
        result.setHost$okhttp($this$commonNewBuilder.host());
        result.setPort$okhttp($this$commonNewBuilder.port() != CommonHttpUrl.commonDefaultPort($this$commonNewBuilder.scheme()) ? $this$commonNewBuilder.port() : -1);
        result.getEncodedPathSegments$okhttp().clear();
        result.getEncodedPathSegments$okhttp().addAll((Collection<String>)$this$commonNewBuilder.encodedPathSegments());
        result.encodedQuery($this$commonNewBuilder.encodedQuery());
        result.setEncodedFragment$okhttp($this$commonNewBuilder.encodedFragment());
        return result;
    }

    @Nullable
    public final HttpUrl.Builder commonNewBuilder(@NotNull HttpUrl $this$commonNewBuilder, @NotNull String link) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNewBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        try {
            builder = new HttpUrl.Builder().parse$okhttp($this$commonNewBuilder, link);
        }
        catch (IllegalArgumentException _) {
            builder = null;
        }
        return builder;
    }

    public final boolean commonEquals(@NotNull HttpUrl $this$commonEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEquals, (String)"<this>");
        return other instanceof HttpUrl && Intrinsics.areEqual((Object)((HttpUrl)other).getUrl$okhttp(), (Object)$this$commonEquals.getUrl$okhttp());
    }

    public final int commonHashCode(@NotNull HttpUrl $this$commonHashCode) {
        Intrinsics.checkNotNullParameter((Object)$this$commonHashCode, (String)"<this>");
        return $this$commonHashCode.getUrl$okhttp().hashCode();
    }

    @NotNull
    public final String commonToString(@NotNull HttpUrl $this$commonToString) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        return $this$commonToString.getUrl$okhttp();
    }

    @JvmStatic
    public static final int commonDefaultPort(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        String string = scheme;
        return Intrinsics.areEqual((Object)string, (Object)"http") ? 80 : (Intrinsics.areEqual((Object)string, (Object)"https") ? 443 : -1);
    }

    @NotNull
    public final HttpUrl.Builder commonScheme(@NotNull HttpUrl.Builder $this$commonScheme, @NotNull String scheme) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonScheme, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        HttpUrl.Builder $this$commonScheme_u24lambda_u240 = builder = $this$commonScheme;
        boolean bl = false;
        if (StringsKt.equals((String)scheme, (String)"http", (boolean)true)) {
            $this$commonScheme_u24lambda_u240.setScheme$okhttp("http");
        } else if (StringsKt.equals((String)scheme, (String)"https", (boolean)true)) {
            $this$commonScheme_u24lambda_u240.setScheme$okhttp("https");
        } else {
            throw new IllegalArgumentException("unexpected scheme: " + scheme);
        }
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonUsername(@NotNull HttpUrl.Builder $this$commonUsername, @NotNull String username) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonUsername, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        HttpUrl.Builder $this$commonUsername_u24lambda_u241 = builder = $this$commonUsername;
        boolean bl = false;
        $this$commonUsername_u24lambda_u241.setEncodedUsername$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, username, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, 123, null));
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonEncodedUsername(@NotNull HttpUrl.Builder $this$commonEncodedUsername, @NotNull String encodedUsername) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedUsername, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedUsername, (String)"encodedUsername");
        HttpUrl.Builder $this$commonEncodedUsername_u24lambda_u242 = builder = $this$commonEncodedUsername;
        boolean bl = false;
        $this$commonEncodedUsername_u24lambda_u242.setEncodedUsername$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, encodedUsername, 0, 0, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 115, null));
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonPassword(@NotNull HttpUrl.Builder $this$commonPassword, @NotNull String password) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonPassword, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        HttpUrl.Builder $this$commonPassword_u24lambda_u243 = builder = $this$commonPassword;
        boolean bl = false;
        $this$commonPassword_u24lambda_u243.setEncodedPassword$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, password, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, 123, null));
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonEncodedPassword(@NotNull HttpUrl.Builder $this$commonEncodedPassword, @NotNull String encodedPassword) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedPassword, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        HttpUrl.Builder $this$commonEncodedPassword_u24lambda_u244 = builder = $this$commonEncodedPassword;
        boolean bl = false;
        $this$commonEncodedPassword_u24lambda_u244.setEncodedPassword$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, encodedPassword, 0, 0, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 115, null));
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonHost(@NotNull HttpUrl.Builder $this$commonHost, @NotNull String host) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonHost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        HttpUrl.Builder $this$commonHost_u24lambda_u245 = builder = $this$commonHost;
        boolean bl = false;
        String string = _HostnamesCommonKt.toCanonicalHost(CommonHttpUrl.percentDecode$okhttp$default(INSTANCE, host, 0, 0, false, 7, null));
        if (string == null) {
            throw new IllegalArgumentException("unexpected host: " + host);
        }
        String encoded = string;
        $this$commonHost_u24lambda_u245.setHost$okhttp(encoded);
        return builder;
    }

    @NotNull
    public final String percentDecode$okhttp(@NotNull String $this$percentDecode, int pos, int limit, boolean plusIsSpace) {
        Intrinsics.checkNotNullParameter((Object)$this$percentDecode, (String)"<this>");
        for (int i = pos; i < limit; ++i) {
            char c = $this$percentDecode.charAt(i);
            if (c != '%' && (c != '+' || !plusIsSpace)) continue;
            Buffer out = new Buffer();
            out.writeUtf8($this$percentDecode, pos, i);
            HttpUrlCommon.INSTANCE.writePercentDecoded$okhttp(out, $this$percentDecode, i, limit, plusIsSpace);
            return out.readUtf8();
        }
        String string = $this$percentDecode.substring(pos, limit);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public static /* synthetic */ String percentDecode$okhttp$default(CommonHttpUrl commonHttpUrl, String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return commonHttpUrl.percentDecode$okhttp(string, n, n2, bl);
    }

    @NotNull
    public final HttpUrl.Builder commonPort(@NotNull HttpUrl.Builder $this$commonPort, int port) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonPort, (String)"<this>");
        HttpUrl.Builder $this$commonPort_u24lambda_u247 = builder = $this$commonPort;
        boolean bl = false;
        if (!(1 <= port ? port < 65536 : false)) {
            boolean bl2 = false;
            String string = "unexpected port: " + port;
            throw new IllegalArgumentException(string.toString());
        }
        $this$commonPort_u24lambda_u247.setPort$okhttp(port);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonAddPathSegment(@NotNull HttpUrl.Builder $this$commonAddPathSegment, @NotNull String pathSegment) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonAddPathSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
        HttpUrl.Builder $this$commonAddPathSegment_u24lambda_u248 = builder = $this$commonAddPathSegment;
        boolean bl = false;
        INSTANCE.push$okhttp($this$commonAddPathSegment_u24lambda_u248, pathSegment, 0, pathSegment.length(), false, false);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonAddPathSegments(@NotNull HttpUrl.Builder $this$commonAddPathSegments, @NotNull String pathSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$commonAddPathSegments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathSegments, (String)"pathSegments");
        return this.commonAddPathSegments($this$commonAddPathSegments, pathSegments, false);
    }

    @NotNull
    public final HttpUrl.Builder commonAddEncodedPathSegment(@NotNull HttpUrl.Builder $this$commonAddEncodedPathSegment, @NotNull String encodedPathSegment) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonAddEncodedPathSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPathSegment, (String)"encodedPathSegment");
        HttpUrl.Builder $this$commonAddEncodedPathSegment_u24lambda_u249 = builder = $this$commonAddEncodedPathSegment;
        boolean bl = false;
        INSTANCE.push$okhttp($this$commonAddEncodedPathSegment_u24lambda_u249, encodedPathSegment, 0, encodedPathSegment.length(), false, true);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonAddEncodedPathSegments(@NotNull HttpUrl.Builder $this$commonAddEncodedPathSegments, @NotNull String encodedPathSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$commonAddEncodedPathSegments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPathSegments, (String)"encodedPathSegments");
        return this.commonAddPathSegments($this$commonAddEncodedPathSegments, encodedPathSegments, true);
    }

    private final HttpUrl.Builder commonAddPathSegments(HttpUrl.Builder $this$commonAddPathSegments, String pathSegments, boolean alreadyEncoded) {
        int segmentEnd;
        HttpUrl.Builder builder;
        HttpUrl.Builder $this$commonAddPathSegments_u24lambda_u2410 = builder = $this$commonAddPathSegments;
        boolean bl = false;
        int offset = 0;
        do {
            boolean addTrailingSlash = (segmentEnd = _UtilCommonKt.delimiterOffset(pathSegments, "/\\", offset, pathSegments.length())) < pathSegments.length();
            INSTANCE.push$okhttp($this$commonAddPathSegments_u24lambda_u2410, pathSegments, offset, segmentEnd, addTrailingSlash, alreadyEncoded);
        } while ((offset = segmentEnd + 1) <= pathSegments.length());
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonSetPathSegment(@NotNull HttpUrl.Builder $this$commonSetPathSegment, int index, @NotNull String pathSegment) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonSetPathSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
        HttpUrl.Builder $this$commonSetPathSegment_u24lambda_u2412 = builder = $this$commonSetPathSegment;
        boolean bl = false;
        String canonicalPathSegment = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, pathSegment, 0, 0, PATH_SEGMENT_ENCODE_SET, false, false, false, false, 123, null);
        if (!(!INSTANCE.isDot$okhttp($this$commonSetPathSegment_u24lambda_u2412, canonicalPathSegment) && !INSTANCE.isDotDot$okhttp($this$commonSetPathSegment_u24lambda_u2412, canonicalPathSegment))) {
            boolean bl2 = false;
            String string = "unexpected path segment: " + pathSegment;
            throw new IllegalArgumentException(string.toString());
        }
        $this$commonSetPathSegment_u24lambda_u2412.getEncodedPathSegments$okhttp().set(index, canonicalPathSegment);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonSetEncodedPathSegment(@NotNull HttpUrl.Builder $this$commonSetEncodedPathSegment, int index, @NotNull String encodedPathSegment) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonSetEncodedPathSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPathSegment, (String)"encodedPathSegment");
        HttpUrl.Builder $this$commonSetEncodedPathSegment_u24lambda_u2414 = builder = $this$commonSetEncodedPathSegment;
        boolean bl = false;
        String canonicalPathSegment = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, encodedPathSegment, 0, 0, PATH_SEGMENT_ENCODE_SET, true, false, false, false, 115, null);
        $this$commonSetEncodedPathSegment_u24lambda_u2414.getEncodedPathSegments$okhttp().set(index, canonicalPathSegment);
        if (!(!INSTANCE.isDot$okhttp($this$commonSetEncodedPathSegment_u24lambda_u2414, canonicalPathSegment) && !INSTANCE.isDotDot$okhttp($this$commonSetEncodedPathSegment_u24lambda_u2414, canonicalPathSegment))) {
            boolean bl2 = false;
            String string = "unexpected path segment: " + encodedPathSegment;
            throw new IllegalArgumentException(string.toString());
        }
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonRemovePathSegment(@NotNull HttpUrl.Builder $this$commonRemovePathSegment, int index) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonRemovePathSegment, (String)"<this>");
        HttpUrl.Builder $this$commonRemovePathSegment_u24lambda_u2415 = builder = $this$commonRemovePathSegment;
        boolean bl = false;
        $this$commonRemovePathSegment_u24lambda_u2415.getEncodedPathSegments$okhttp().remove(index);
        if ($this$commonRemovePathSegment_u24lambda_u2415.getEncodedPathSegments$okhttp().isEmpty()) {
            $this$commonRemovePathSegment_u24lambda_u2415.getEncodedPathSegments$okhttp().add(FRAGMENT_ENCODE_SET);
        }
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonEncodedPath(@NotNull HttpUrl.Builder $this$commonEncodedPath, @NotNull String encodedPath) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        HttpUrl.Builder $this$commonEncodedPath_u24lambda_u2417 = builder = $this$commonEncodedPath;
        boolean bl = false;
        if (!StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
            boolean bl2 = false;
            String string = "unexpected encodedPath: " + encodedPath;
            throw new IllegalArgumentException(string.toString());
        }
        INSTANCE.resolvePath$okhttp($this$commonEncodedPath_u24lambda_u2417, encodedPath, 0, encodedPath.length());
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonQuery(@NotNull HttpUrl.Builder $this$commonQuery, @Nullable String query) {
        String string;
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonQuery, (String)"<this>");
        HttpUrl.Builder $this$commonQuery_u24lambda_u2418 = builder = $this$commonQuery;
        boolean bl = false;
        $this$commonQuery_u24lambda_u2418.setEncodedQueryNamesAndValues$okhttp(query != null && (string = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, query, 0, 0, QUERY_ENCODE_SET, false, false, true, false, 91, null)) != null ? INSTANCE.toQueryNamesAndValues$okhttp(string) : null);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonEncodedQuery(@NotNull HttpUrl.Builder $this$commonEncodedQuery, @Nullable String encodedQuery) {
        String string;
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedQuery, (String)"<this>");
        HttpUrl.Builder $this$commonEncodedQuery_u24lambda_u2419 = builder = $this$commonEncodedQuery;
        boolean bl = false;
        $this$commonEncodedQuery_u24lambda_u2419.setEncodedQueryNamesAndValues$okhttp(encodedQuery != null && (string = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, encodedQuery, 0, 0, QUERY_ENCODE_SET, true, false, true, false, 83, null)) != null ? INSTANCE.toQueryNamesAndValues$okhttp(string) : null);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonAddQueryParameter(@NotNull HttpUrl.Builder $this$commonAddQueryParameter, @NotNull String name, @Nullable String value) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonAddQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HttpUrl.Builder $this$commonAddQueryParameter_u24lambda_u2420 = builder = $this$commonAddQueryParameter;
        boolean bl = false;
        if ($this$commonAddQueryParameter_u24lambda_u2420.getEncodedQueryNamesAndValues$okhttp() == null) {
            $this$commonAddQueryParameter_u24lambda_u2420.setEncodedQueryNamesAndValues$okhttp(new ArrayList());
        }
        List<String> list = $this$commonAddQueryParameter_u24lambda_u2420.getEncodedQueryNamesAndValues$okhttp();
        Intrinsics.checkNotNull(list);
        list.add(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, name, 0, 0, QUERY_COMPONENT_ENCODE_SET, false, false, true, false, 91, null));
        List<String> list2 = $this$commonAddQueryParameter_u24lambda_u2420.getEncodedQueryNamesAndValues$okhttp();
        Intrinsics.checkNotNull(list2);
        String string = value;
        list2.add(string != null ? HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, string, 0, 0, QUERY_COMPONENT_ENCODE_SET, false, false, true, false, 91, null) : null);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonAddEncodedQueryParameter(@NotNull HttpUrl.Builder $this$commonAddEncodedQueryParameter, @NotNull String encodedName, @Nullable String encodedValue) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonAddEncodedQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
        HttpUrl.Builder $this$commonAddEncodedQueryParameter_u24lambda_u2421 = builder = $this$commonAddEncodedQueryParameter;
        boolean bl = false;
        if ($this$commonAddEncodedQueryParameter_u24lambda_u2421.getEncodedQueryNamesAndValues$okhttp() == null) {
            $this$commonAddEncodedQueryParameter_u24lambda_u2421.setEncodedQueryNamesAndValues$okhttp(new ArrayList());
        }
        List<String> list = $this$commonAddEncodedQueryParameter_u24lambda_u2421.getEncodedQueryNamesAndValues$okhttp();
        Intrinsics.checkNotNull(list);
        list.add(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, encodedName, 0, 0, QUERY_COMPONENT_REENCODE_SET, true, false, true, false, 83, null));
        List<String> list2 = $this$commonAddEncodedQueryParameter_u24lambda_u2421.getEncodedQueryNamesAndValues$okhttp();
        Intrinsics.checkNotNull(list2);
        String string = encodedValue;
        list2.add(string != null ? HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, string, 0, 0, QUERY_COMPONENT_REENCODE_SET, true, false, true, false, 83, null) : null);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonSetQueryParameter(@NotNull HttpUrl.Builder $this$commonSetQueryParameter, @NotNull String name, @Nullable String value) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonSetQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HttpUrl.Builder $this$commonSetQueryParameter_u24lambda_u2422 = builder = $this$commonSetQueryParameter;
        boolean bl = false;
        $this$commonSetQueryParameter_u24lambda_u2422.removeAllQueryParameters(name);
        $this$commonSetQueryParameter_u24lambda_u2422.addQueryParameter(name, value);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonSetEncodedQueryParameter(@NotNull HttpUrl.Builder $this$commonSetEncodedQueryParameter, @NotNull String encodedName, @Nullable String encodedValue) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonSetEncodedQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
        HttpUrl.Builder $this$commonSetEncodedQueryParameter_u24lambda_u2423 = builder = $this$commonSetEncodedQueryParameter;
        boolean bl = false;
        $this$commonSetEncodedQueryParameter_u24lambda_u2423.removeAllEncodedQueryParameters(encodedName);
        $this$commonSetEncodedQueryParameter_u24lambda_u2423.addEncodedQueryParameter(encodedName, encodedValue);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonRemoveAllQueryParameters(@NotNull HttpUrl.Builder $this$commonRemoveAllQueryParameters, @NotNull String name) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonRemoveAllQueryParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HttpUrl.Builder $this$commonRemoveAllQueryParameters_u24lambda_u2424 = builder = $this$commonRemoveAllQueryParameters;
        boolean bl = false;
        if ($this$commonRemoveAllQueryParameters_u24lambda_u2424.getEncodedQueryNamesAndValues$okhttp() == null) {
            return $this$commonRemoveAllQueryParameters_u24lambda_u2424;
        }
        String nameToRemove = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, name, 0, 0, QUERY_COMPONENT_ENCODE_SET, false, false, true, false, 91, null);
        INSTANCE.commonRemoveAllCanonicalQueryParameters($this$commonRemoveAllQueryParameters_u24lambda_u2424, nameToRemove);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonRemoveAllEncodedQueryParameters(@NotNull HttpUrl.Builder $this$commonRemoveAllEncodedQueryParameters, @NotNull String encodedName) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonRemoveAllEncodedQueryParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
        HttpUrl.Builder $this$commonRemoveAllEncodedQueryParameters_u24lambda_u2425 = builder = $this$commonRemoveAllEncodedQueryParameters;
        boolean bl = false;
        if ($this$commonRemoveAllEncodedQueryParameters_u24lambda_u2425.getEncodedQueryNamesAndValues$okhttp() == null) {
            return $this$commonRemoveAllEncodedQueryParameters_u24lambda_u2425;
        }
        INSTANCE.commonRemoveAllCanonicalQueryParameters($this$commonRemoveAllEncodedQueryParameters_u24lambda_u2425, HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, encodedName, 0, 0, QUERY_COMPONENT_REENCODE_SET, true, false, true, false, 83, null));
        return builder;
    }

    public final void commonRemoveAllCanonicalQueryParameters(@NotNull HttpUrl.Builder $this$commonRemoveAllCanonicalQueryParameters, @NotNull String canonicalName) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$commonRemoveAllCanonicalQueryParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        List<String> list = $this$commonRemoveAllCanonicalQueryParameters.getEncodedQueryNamesAndValues$okhttp();
        Intrinsics.checkNotNull(list);
        int i = n = list.size() - 2;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
        if (n2 <= i) {
            while (true) {
                List<String> list2 = $this$commonRemoveAllCanonicalQueryParameters.getEncodedQueryNamesAndValues$okhttp();
                Intrinsics.checkNotNull(list2);
                if (Intrinsics.areEqual((Object)canonicalName, (Object)list2.get(i))) {
                    List<String> list3 = $this$commonRemoveAllCanonicalQueryParameters.getEncodedQueryNamesAndValues$okhttp();
                    Intrinsics.checkNotNull(list3);
                    list3.remove(i + 1);
                    List<String> list4 = $this$commonRemoveAllCanonicalQueryParameters.getEncodedQueryNamesAndValues$okhttp();
                    Intrinsics.checkNotNull(list4);
                    list4.remove(i);
                    List<String> list5 = $this$commonRemoveAllCanonicalQueryParameters.getEncodedQueryNamesAndValues$okhttp();
                    Intrinsics.checkNotNull(list5);
                    if (list5.isEmpty()) {
                        $this$commonRemoveAllCanonicalQueryParameters.setEncodedQueryNamesAndValues$okhttp(null);
                        return;
                    }
                }
                if (i == n2) break;
                i -= 2;
            }
        }
    }

    @NotNull
    public final HttpUrl.Builder commonFragment(@NotNull HttpUrl.Builder $this$commonFragment, @Nullable String fragment) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonFragment, (String)"<this>");
        HttpUrl.Builder $this$commonFragment_u24lambda_u2426 = builder = $this$commonFragment;
        boolean bl = false;
        String string = fragment;
        $this$commonFragment_u24lambda_u2426.setEncodedFragment$okhttp(string != null ? HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, string, 0, 0, FRAGMENT_ENCODE_SET, false, false, false, true, 59, null) : null);
        return builder;
    }

    @NotNull
    public final HttpUrl.Builder commonEncodedFragment(@NotNull HttpUrl.Builder $this$commonEncodedFragment, @Nullable String encodedFragment) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonEncodedFragment, (String)"<this>");
        HttpUrl.Builder $this$commonEncodedFragment_u24lambda_u2427 = builder = $this$commonEncodedFragment;
        boolean bl = false;
        String string = encodedFragment;
        $this$commonEncodedFragment_u24lambda_u2427.setEncodedFragment$okhttp(string != null ? HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, string, 0, 0, FRAGMENT_ENCODE_SET, true, false, false, true, 51, null) : null);
        return builder;
    }

    public final void push$okhttp(@NotNull HttpUrl.Builder $this$push, @NotNull String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$push, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String segment = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, pos, limit, PATH_SEGMENT_ENCODE_SET, alreadyEncoded, false, false, false, 112, null);
        if (this.isDot$okhttp($this$push, segment)) {
            return;
        }
        if (this.isDotDot$okhttp($this$push, segment)) {
            this.pop$okhttp($this$push);
            return;
        }
        if (((CharSequence)$this$push.getEncodedPathSegments$okhttp().get($this$push.getEncodedPathSegments$okhttp().size() - 1)).length() == 0) {
            $this$push.getEncodedPathSegments$okhttp().set($this$push.getEncodedPathSegments$okhttp().size() - 1, segment);
        } else {
            $this$push.getEncodedPathSegments$okhttp().add(segment);
        }
        if (addTrailingSlash) {
            $this$push.getEncodedPathSegments$okhttp().add(FRAGMENT_ENCODE_SET);
        }
    }

    public final boolean isDot$okhttp(@NotNull HttpUrl.Builder $this$isDot, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)$this$isDot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Intrinsics.areEqual((Object)input, (Object)".") || StringsKt.equals((String)input, (String)"%2e", (boolean)true);
    }

    public final boolean isDotDot$okhttp(@NotNull HttpUrl.Builder $this$isDotDot, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)$this$isDotDot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Intrinsics.areEqual((Object)input, (Object)"..") || StringsKt.equals((String)input, (String)"%2e.", (boolean)true) || StringsKt.equals((String)input, (String)".%2e", (boolean)true) || StringsKt.equals((String)input, (String)"%2e%2e", (boolean)true);
    }

    public final void pop$okhttp(@NotNull HttpUrl.Builder $this$pop) {
        Intrinsics.checkNotNullParameter((Object)$this$pop, (String)"<this>");
        String removed = $this$pop.getEncodedPathSegments$okhttp().remove($this$pop.getEncodedPathSegments$okhttp().size() - 1);
        if (((CharSequence)removed).length() == 0 && !((Collection)$this$pop.getEncodedPathSegments$okhttp()).isEmpty()) {
            $this$pop.getEncodedPathSegments$okhttp().set($this$pop.getEncodedPathSegments$okhttp().size() - 1, FRAGMENT_ENCODE_SET);
        } else {
            $this$pop.getEncodedPathSegments$okhttp().add(FRAGMENT_ENCODE_SET);
        }
    }

    public final void resolvePath$okhttp(@NotNull HttpUrl.Builder $this$resolvePath, @NotNull String input, int startPos, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int pos = startPos;
        if (pos == limit) {
            return;
        }
        char c = input.charAt(pos);
        if (c == '/' || c == '\\') {
            $this$resolvePath.getEncodedPathSegments$okhttp().clear();
            $this$resolvePath.getEncodedPathSegments$okhttp().add(FRAGMENT_ENCODE_SET);
            ++pos;
        } else {
            $this$resolvePath.getEncodedPathSegments$okhttp().set($this$resolvePath.getEncodedPathSegments$okhttp().size() - 1, FRAGMENT_ENCODE_SET);
        }
        int i = pos;
        while (i < limit) {
            int pathSegmentDelimiterOffset = _UtilCommonKt.delimiterOffset(input, "/\\", i, limit);
            boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
            this.push$okhttp($this$resolvePath, input, i, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
            i = pathSegmentDelimiterOffset;
            if (!segmentHasTrailingSlash) continue;
            ++i;
        }
    }

    @NotNull
    public final List<String> toQueryNamesAndValues$okhttp(@NotNull String $this$toQueryNamesAndValues) {
        Intrinsics.checkNotNullParameter((Object)$this$toQueryNamesAndValues, (String)"<this>");
        List result = new ArrayList();
        int pos = 0;
        while (pos <= $this$toQueryNamesAndValues.length()) {
            int equalsOffset;
            int ampersandOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'&', (int)pos, (boolean)false, (int)4, null);
            if (ampersandOffset == -1) {
                ampersandOffset = $this$toQueryNamesAndValues.length();
            }
            if ((equalsOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'=', (int)pos, (boolean)false, (int)4, null)) == -1 || equalsOffset > ampersandOffset) {
                String string = $this$toQueryNamesAndValues.substring(pos, ampersandOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.add(string);
                result.add(null);
            } else {
                String string = $this$toQueryNamesAndValues.substring(pos, equalsOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.add(string);
                String string2 = $this$toQueryNamesAndValues.substring(equalsOffset + 1, ampersandOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                result.add(string2);
            }
            pos = ampersandOffset + 1;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpUrl commonBuild(@NotNull HttpUrl.Builder $this$commonBuild) {
        Collection<String> collection;
        Collection<String> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$commonBuild, (String)"<this>");
        String string = $this$commonBuild.getScheme$okhttp();
        if (string == null) {
            throw new IllegalStateException("scheme == null");
        }
        String string2 = $this$commonBuild.getHost$okhttp();
        if (string2 == null) {
            throw new IllegalStateException("host == null");
        }
        Iterable iterable = $this$commonBuild.getEncodedPathSegments$okhttp();
        int n = this.effectivePort$okhttp($this$commonBuild);
        String string3 = string2;
        String string4 = CommonHttpUrl.percentDecode$okhttp$default(this, $this$commonBuild.getEncodedPassword$okhttp(), 0, 0, false, 7, null);
        String string5 = CommonHttpUrl.percentDecode$okhttp$default(this, $this$commonBuild.getEncodedUsername$okhttp(), 0, 0, false, 7, null);
        String string6 = string;
        boolean $i$f$map2 = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string7 = (String)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CommonHttpUrl.percentDecode$okhttp$default(INSTANCE, (String)it, 0, 0, false, 7, null));
        }
        collection2 = (List)destination$iv$iv;
        String string8 = string6;
        String string9 = string5;
        String string10 = string4;
        String string11 = string3;
        int n2 = n;
        Collection<String> collection3 = collection2;
        List<String> list = $this$commonBuild.getEncodedQueryNamesAndValues$okhttp();
        if (list != null) {
            Collection<String> collection4;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable $i$f$map2 = list;
            collection2 = collection3;
            n = n2;
            string3 = string11;
            string4 = string10;
            string5 = string9;
            string6 = string8;
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection4 = destination$iv$iv2;
                boolean bl2 = false;
                void v9 = it;
                collection4.add(v9 != null ? CommonHttpUrl.percentDecode$okhttp$default(INSTANCE, (String)v9, 0, 0, true, 3, null) : null);
            }
            collection4 = (List)destination$iv$iv2;
            string8 = string6;
            string9 = string5;
            string10 = string4;
            string11 = string3;
            n2 = n;
            collection3 = collection2;
            collection = collection4;
        } else {
            collection = null;
        }
        String string12 = $this$commonBuild.getEncodedFragment$okhttp();
        String string13 = $this$commonBuild.toString();
        String string14 = string12 != null ? CommonHttpUrl.percentDecode$okhttp$default(this, string12, 0, 0, false, 7, null) : null;
        Collection<String> collection5 = collection;
        Collection<String> collection6 = collection3;
        int n3 = n2;
        String string15 = string11;
        String string16 = string10;
        String string17 = string9;
        String string18 = string8;
        return new HttpUrl(string18, string17, string16, string15, n3, (List<String>)collection6, (List<String>)collection5, string14, string13);
    }

    public final int effectivePort$okhttp(@NotNull HttpUrl.Builder $this$effectivePort) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$effectivePort, (String)"<this>");
        if ($this$effectivePort.getPort$okhttp() != -1) {
            n = $this$effectivePort.getPort$okhttp();
        } else {
            String string = $this$effectivePort.getScheme$okhttp();
            Intrinsics.checkNotNull((Object)string);
            n = HttpUrl.Companion.defaultPort(string);
        }
        return n;
    }

    @NotNull
    public final String commonToString$okhttp(@NotNull HttpUrl.Builder $this$commonToString) {
        StringBuilder $this$commonToString_u24lambda_u2430;
        StringBuilder stringBuilder;
        block12: {
            int effectivePort;
            block13: {
                Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
                $this$commonToString_u24lambda_u2430 = stringBuilder = new StringBuilder();
                boolean bl = false;
                if ($this$commonToString.getScheme$okhttp() != null) {
                    $this$commonToString_u24lambda_u2430.append($this$commonToString.getScheme$okhttp());
                    $this$commonToString_u24lambda_u2430.append("://");
                } else {
                    $this$commonToString_u24lambda_u2430.append("//");
                }
                if (((CharSequence)$this$commonToString.getEncodedUsername$okhttp()).length() > 0 || ((CharSequence)$this$commonToString.getEncodedPassword$okhttp()).length() > 0) {
                    $this$commonToString_u24lambda_u2430.append($this$commonToString.getEncodedUsername$okhttp());
                    if (((CharSequence)$this$commonToString.getEncodedPassword$okhttp()).length() > 0) {
                        $this$commonToString_u24lambda_u2430.append(':');
                        $this$commonToString_u24lambda_u2430.append($this$commonToString.getEncodedPassword$okhttp());
                    }
                    $this$commonToString_u24lambda_u2430.append('@');
                }
                if ($this$commonToString.getHost$okhttp() != null) {
                    String string = $this$commonToString.getHost$okhttp();
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.contains$default((CharSequence)string, (char)':', (boolean)false, (int)2, null)) {
                        $this$commonToString_u24lambda_u2430.append('[');
                        $this$commonToString_u24lambda_u2430.append($this$commonToString.getHost$okhttp());
                        $this$commonToString_u24lambda_u2430.append(']');
                    } else {
                        $this$commonToString_u24lambda_u2430.append($this$commonToString.getHost$okhttp());
                    }
                }
                if ($this$commonToString.getPort$okhttp() == -1 && $this$commonToString.getScheme$okhttp() == null) break block12;
                effectivePort = INSTANCE.effectivePort$okhttp($this$commonToString);
                if ($this$commonToString.getScheme$okhttp() == null) break block13;
                String string = $this$commonToString.getScheme$okhttp();
                Intrinsics.checkNotNull((Object)string);
                if (effectivePort == HttpUrl.Companion.defaultPort(string)) break block12;
            }
            $this$commonToString_u24lambda_u2430.append(':');
            $this$commonToString_u24lambda_u2430.append(effectivePort);
        }
        INSTANCE.toPathString$okhttp($this$commonToString.getEncodedPathSegments$okhttp(), $this$commonToString_u24lambda_u2430);
        if ($this$commonToString.getEncodedQueryNamesAndValues$okhttp() != null) {
            $this$commonToString_u24lambda_u2430.append('?');
            List<String> list = $this$commonToString.getEncodedQueryNamesAndValues$okhttp();
            Intrinsics.checkNotNull(list);
            INSTANCE.toQueryString$okhttp(list, $this$commonToString_u24lambda_u2430);
        }
        if ($this$commonToString.getEncodedFragment$okhttp() != null) {
            $this$commonToString_u24lambda_u2430.append('#');
            $this$commonToString_u24lambda_u2430.append($this$commonToString.getEncodedFragment$okhttp());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void toPathString$okhttp(@NotNull List<String> $this$toPathString, @NotNull StringBuilder out) {
        Intrinsics.checkNotNullParameter($this$toPathString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = $this$toPathString.size();
        for (int i = 0; i < n; ++i) {
            out.append('/');
            out.append($this$toPathString.get(i));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final HttpUrl.Builder commonParse$okhttp(@NotNull HttpUrl.Builder $this$commonParse, @Nullable HttpUrl base, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)$this$commonParse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int pos = 0;
        pos = _UtilCommonKt.indexOfFirstNonAsciiWhitespace$default(input, 0, 0, 3, null);
        int limit = _UtilCommonKt.indexOfLastNonAsciiWhitespace$default(input, pos, 0, 2, null);
        int schemeDelimiterOffset = this.schemeDelimiterOffset$okhttp(input, pos, limit);
        if (schemeDelimiterOffset != -1) {
            if (StringsKt.startsWith((String)input, (String)"https:", (int)pos, (boolean)true)) {
                $this$commonParse.setScheme$okhttp("https");
                pos += 6;
            } else {
                if (!StringsKt.startsWith((String)input, (String)"http:", (int)pos, (boolean)true)) {
                    StringBuilder stringBuilder = new StringBuilder().append("Expected URL scheme 'http' or 'https' but was '");
                    String string = input.substring(0, schemeDelimiterOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    throw new IllegalArgumentException(stringBuilder.append(string).append('\'').toString());
                }
                $this$commonParse.setScheme$okhttp("http");
                pos += 5;
            }
        } else if (base != null) {
            $this$commonParse.setScheme$okhttp(base.scheme());
        } else {
            String truncated = input.length() > 6 ? StringsKt.take((String)input, (int)6) + "..." : input;
            throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no scheme was found for " + truncated);
        }
        boolean hasUsername = false;
        boolean hasPassword = false;
        int slashCount = this.slashCount$okhttp(input, pos, limit);
        if (slashCount < 2 && base != null && Intrinsics.areEqual((Object)base.scheme(), (Object)$this$commonParse.getScheme$okhttp())) {
            $this$commonParse.setEncodedUsername$okhttp(base.encodedUsername());
            $this$commonParse.setEncodedPassword$okhttp(base.encodedPassword());
            $this$commonParse.setHost$okhttp(base.host());
            $this$commonParse.setPort$okhttp(base.port());
            $this$commonParse.getEncodedPathSegments$okhttp().clear();
            $this$commonParse.getEncodedPathSegments$okhttp().addAll((Collection<String>)base.encodedPathSegments());
            if (pos == limit || input.charAt(pos) == '#') {
                $this$commonParse.encodedQuery(base.encodedQuery());
            }
        } else {
            pos += slashCount;
            block4: while (true) {
                int componentDelimiterOffset;
                int c = (componentDelimiterOffset = _UtilCommonKt.delimiterOffset(input, "@/\\?#", pos, limit)) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                switch (c) {
                    case 64: {
                        if (!hasPassword) {
                            int passwordColonOffset = _UtilCommonKt.delimiterOffset(input, ':', pos, componentDelimiterOffset);
                            String canonicalUsername = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 112, null);
                            $this$commonParse.setEncodedUsername$okhttp(hasUsername ? $this$commonParse.getEncodedUsername$okhttp() + "%40" + canonicalUsername : canonicalUsername);
                            if (passwordColonOffset != componentDelimiterOffset) {
                                hasPassword = true;
                                $this$commonParse.setEncodedPassword$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 112, null));
                            }
                            hasUsername = true;
                        } else {
                            $this$commonParse.setEncodedPassword$okhttp($this$commonParse.getEncodedPassword$okhttp() + "%40" + HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, 112, null));
                        }
                        pos = componentDelimiterOffset + 1;
                        continue block4;
                    }
                    case -1: 
                    case 35: 
                    case 47: 
                    case 63: 
                    case 92: {
                        int portColonOffset = this.portColonOffset$okhttp(input, pos, componentDelimiterOffset);
                        if (portColonOffset + 1 < componentDelimiterOffset) {
                            $this$commonParse.setHost$okhttp(_HostnamesCommonKt.toCanonicalHost(CommonHttpUrl.percentDecode$okhttp$default(this, input, pos, portColonOffset, false, 4, null)));
                            $this$commonParse.setPort$okhttp(this.parsePort$okhttp(input, portColonOffset + 1, componentDelimiterOffset));
                            if (!($this$commonParse.getPort$okhttp() != -1)) {
                                boolean $i$a$-require-CommonHttpUrl$commonParse$32 = false;
                                StringBuilder stringBuilder = new StringBuilder().append("Invalid URL port: \"");
                                String string = input.substring(portColonOffset + 1, componentDelimiterOffset);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                String $i$a$-require-CommonHttpUrl$commonParse$32 = stringBuilder.append(string).append('\"').toString();
                                throw new IllegalArgumentException($i$a$-require-CommonHttpUrl$commonParse$32.toString());
                            }
                        } else {
                            $this$commonParse.setHost$okhttp(_HostnamesCommonKt.toCanonicalHost(CommonHttpUrl.percentDecode$okhttp$default(this, input, pos, portColonOffset, false, 4, null)));
                            String string = $this$commonParse.getScheme$okhttp();
                            Intrinsics.checkNotNull((Object)string);
                            $this$commonParse.setPort$okhttp(HttpUrl.Companion.defaultPort(string));
                        }
                        if (!($this$commonParse.getHost$okhttp() != null)) {
                            boolean bl = false;
                            StringBuilder stringBuilder = new StringBuilder().append("Invalid URL host: \"");
                            String string = input.substring(pos, portColonOffset);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            String string2 = stringBuilder.append(string).append('\"').toString();
                            throw new IllegalArgumentException(string2.toString());
                        }
                        pos = componentDelimiterOffset;
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                break;
            }
        }
        int pathDelimiterOffset = _UtilCommonKt.delimiterOffset(input, "?#", pos, limit);
        this.resolvePath$okhttp($this$commonParse, input, pos, pathDelimiterOffset);
        pos = pathDelimiterOffset;
        if (pos < limit && input.charAt(pos) == '?') {
            int queryDelimiterOffset = _UtilCommonKt.delimiterOffset(input, '#', pos, limit);
            $this$commonParse.setEncodedQueryNamesAndValues$okhttp(this.toQueryNamesAndValues$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, pos + 1, queryDelimiterOffset, QUERY_ENCODE_SET, true, false, true, false, 80, null)));
            pos = queryDelimiterOffset;
        }
        if (pos < limit && input.charAt(pos) == '#') {
            $this$commonParse.setEncodedFragment$okhttp(HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, pos + 1, limit, FRAGMENT_ENCODE_SET, true, false, false, true, 48, null));
        }
        return $this$commonParse;
    }

    public final int schemeDelimiterOffset$okhttp(@NotNull String input, int pos, int limit) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (limit - pos < 2) {
            return -1;
        }
        char c0 = input.charAt(pos);
        if (!(Intrinsics.compare((int)c0, (int)97) >= 0 && Intrinsics.compare((int)c0, (int)122) <= 0 || Intrinsics.compare((int)c0, (int)65) >= 0 && Intrinsics.compare((int)c0, (int)90) <= 0)) {
            return -1;
        }
        for (int i = pos + 1; i < limit; ++i) {
            char c = input.charAt(i);
            if (((((('a' <= c ? c < '{' : false) ? true : ('A' <= c ? c < '[' : false)) ? true : ('0' <= c ? c < ':' : false)) ? true : c == '+') ? true : c == '-') ? true : c == '.') continue;
            return c == ':' ? i : -1;
        }
        return -1;
    }

    public final int slashCount$okhttp(@NotNull String $this$slashCount, int pos, int limit) {
        char c;
        Intrinsics.checkNotNullParameter((Object)$this$slashCount, (String)"<this>");
        int slashCount = 0;
        for (int i = pos; i < limit && ((c = $this$slashCount.charAt(i)) == '\\' || c == '/'); ++i) {
            ++slashCount;
        }
        return slashCount;
    }

    public final int portColonOffset$okhttp(@NotNull String input, int pos, int limit) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        for (int i = pos; i < limit; ++i) {
            char c = input.charAt(i);
            if (c == '[') {
                while (++i < limit && input.charAt(i) != ']') {
                }
                continue;
            }
            if (c != ':') continue;
            return i;
        }
        return limit;
    }

    public final int parsePort$okhttp(@NotNull String input, int pos, int limit) {
        int n;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            String portString = HttpUrlCommon.canonicalize$okhttp$default(HttpUrlCommon.INSTANCE, input, pos, limit, FRAGMENT_ENCODE_SET, false, false, false, false, 120, null);
            int i = Integer.parseInt(portString);
            n = (1 <= i ? i < 65536 : false) ? i : -1;
        }
        catch (NumberFormatException _) {
            n = -1;
        }
        return n;
    }

    public final boolean isPercentEncoded$okhttp(@NotNull String $this$isPercentEncoded, int pos, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$isPercentEncoded, (String)"<this>");
        return pos + 2 < limit && $this$isPercentEncoded.charAt(pos) == '%' && _UtilCommonKt.parseHexDigit($this$isPercentEncoded.charAt(pos + 1)) != -1 && _UtilCommonKt.parseHexDigit($this$isPercentEncoded.charAt(pos + 2)) != -1;
    }

    @NotNull
    public final HttpUrl commonToHttpUrl$okhttp(@NotNull String $this$commonToHttpUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToHttpUrl, (String)"<this>");
        return new HttpUrl.Builder().parse$okhttp(null, $this$commonToHttpUrl).build();
    }

    @Nullable
    public final HttpUrl commonToHttpUrlOrNull$okhttp(@NotNull String $this$commonToHttpUrlOrNull) {
        HttpUrl httpUrl;
        Intrinsics.checkNotNullParameter((Object)$this$commonToHttpUrlOrNull, (String)"<this>");
        try {
            httpUrl = this.commonToHttpUrl$okhttp($this$commonToHttpUrlOrNull);
        }
        catch (IllegalArgumentException _) {
            httpUrl = null;
        }
        return httpUrl;
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEX_DIGITS = cArray;
    }
}

