/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.internal._UtilCommonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\bH\u0000\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000f\u001a\u00020\b*\u00020\u0003H\u0000\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\b*\u00020\u0003\u001a\f\u0010\u0011\u001a\u00020\u0003*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"PARAMETER", "Lkotlin/text/Regex;", "QUOTED", "", "TOKEN", "TYPE_SUBTYPE", "commonEquals", "", "Lokhttp3/MediaType;", "other", "", "commonHashCode", "", "commonParameter", "name", "commonToMediaType", "commonToMediaTypeOrNull", "commonToString", "okhttp"})
public final class _MediaTypeCommonKt {
    @NotNull
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    @NotNull
    private static final String QUOTED = "\"([^\"]*)\"";
    @NotNull
    private static final Regex TYPE_SUBTYPE = new Regex("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    @NotNull
    private static final Regex PARAMETER = new Regex(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");

    @Nullable
    public static final String commonParameter(@NotNull MediaType $this$commonParameter, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$commonParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = $this$commonParameter.getParameterNamesAndValues$okhttp().length + -1;
        int i = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                if (StringsKt.equals((String)$this$commonParameter.getParameterNamesAndValues$okhttp()[i], (String)name, (boolean)true)) {
                    return $this$commonParameter.getParameterNamesAndValues$okhttp()[i + 1];
                }
                if (i == n2) break;
                i += 2;
            }
        }
        return null;
    }

    public static final boolean commonEquals(@NotNull MediaType $this$commonEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter((Object)$this$commonEquals, (String)"<this>");
        return other instanceof MediaType && Intrinsics.areEqual((Object)((MediaType)other).getMediaType$okhttp(), (Object)$this$commonEquals.getMediaType$okhttp());
    }

    @NotNull
    public static final String commonToString(@NotNull MediaType $this$commonToString) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        return $this$commonToString.getMediaType$okhttp();
    }

    public static final int commonHashCode(@NotNull MediaType $this$commonHashCode) {
        Intrinsics.checkNotNullParameter((Object)$this$commonHashCode, (String)"<this>");
        return $this$commonHashCode.getMediaType$okhttp().hashCode();
    }

    @NotNull
    public static final MediaType commonToMediaType(@NotNull String $this$commonToMediaType) {
        Intrinsics.checkNotNullParameter((Object)$this$commonToMediaType, (String)"<this>");
        MatchResult matchResult = _UtilCommonKt.matchAtPolyfill(TYPE_SUBTYPE, $this$commonToMediaType, 0);
        if (matchResult == null) {
            throw new IllegalArgumentException("No subtype found for: \"" + $this$commonToMediaType + '\"');
        }
        MatchResult typeSubtype = matchResult;
        String string = ((String)typeSubtype.getGroupValues().get(1)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String type = string;
        String string2 = ((String)typeSubtype.getGroupValues().get(2)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String subtype = string2;
        List parameterNamesAndValues = new ArrayList();
        int s = 0;
        s = typeSubtype.getRange().getLast() + 1;
        while (s < $this$commonToMediaType.length()) {
            String string3;
            String name;
            MatchResult parameter = _UtilCommonKt.matchAtPolyfill(PARAMETER, $this$commonToMediaType, s);
            if (!(parameter != null)) {
                boolean $i$a$-require-_MediaTypeCommonKt$commonToMediaType$22 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Parameter is not formatted correctly: \"");
                String string4 = $this$commonToMediaType.substring(s);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                String $i$a$-require-_MediaTypeCommonKt$commonToMediaType$22 = stringBuilder.append(string4).append("\" for: \"").append($this$commonToMediaType).append('\"').toString();
                throw new IllegalArgumentException($i$a$-require-_MediaTypeCommonKt$commonToMediaType$22.toString());
            }
            MatchGroup matchGroup = parameter.getGroups().get(1);
            String string5 = name = matchGroup != null ? matchGroup.getValue() : null;
            if (name == null) {
                s = parameter.getRange().getLast() + 1;
                continue;
            }
            MatchGroup matchGroup2 = parameter.getGroups().get(2);
            String token = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (token == null) {
                MatchGroup matchGroup3 = parameter.getGroups().get(3);
                Intrinsics.checkNotNull((Object)matchGroup3);
                string3 = matchGroup3.getValue();
            } else if (StringsKt.startsWith$default((String)token, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"'", (boolean)false, (int)2, null) && token.length() > 2) {
                String string6 = token.substring(1, token.length() - 1);
                string3 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string3 = token;
            }
            String value = string3;
            ((Collection)parameterNamesAndValues).add(name);
            ((Collection)parameterNamesAndValues).add(value);
            s = parameter.getRange().getLast() + 1;
        }
        Collection $this$toTypedArray$iv = parameterNamesAndValues;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return new MediaType($this$commonToMediaType, type, subtype, stringArray);
    }

    @Nullable
    public static final MediaType commonToMediaTypeOrNull(@NotNull String $this$commonToMediaTypeOrNull) {
        MediaType mediaType;
        Intrinsics.checkNotNullParameter((Object)$this$commonToMediaTypeOrNull, (String)"<this>");
        try {
            mediaType = _MediaTypeCommonKt.commonToMediaType($this$commonToMediaTypeOrNull);
        }
        catch (IllegalArgumentException _) {
            mediaType = null;
        }
        return mediaType;
    }
}

