//[okhttp](../../../index.md)/[okhttp3](../index.md)/[WebSocket](index.md)

# WebSocket

[jvm]\
interface [WebSocket](index.md)

A non-blocking interface to a web socket. Use the [factory](-factory/index.md) to create instances; usually this is [OkHttpClient](../-ok-http-client/index.md).

##  Web Socket Lifecycle

Upon normal operation each web socket progresses through a sequence of states:

- 
   **Connecting:** the initial state of each web socket. Messages may be enqueued but they won't     be transmitted until the web socket is open.
- 
   **Open:** the web socket has been accepted by the remote peer and is fully operational.     Messages in either direction are enqueued for immediate transmission.
- 
   **Closing:** one of the peers on the web socket has initiated a graceful shutdown. The web     socket will continue to transmit already-enqueued messages but will refuse to enqueue new     ones.
- 
   **Closed:** the web socket has transmitted all of its messages and has received all messages     from the peer.

Web sockets may fail due to HTTP upgrade problems, connectivity problems, or if either peer chooses to short-circuit the graceful shutdown process:

- 
   **Canceled:** the web socket connection failed. Messages that were successfully enqueued by     either peer may not have been transmitted to the other.

Note that the state progression is independent for each peer. Arriving at a gracefully-closed state indicates that a peer has sent all of its outgoing messages and received all of its incoming messages. But it does not guarantee that the other peer will successfully receive all of its incoming messages.

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [jvm]<br>fun interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | [jvm]<br>abstract fun [cancel](cancel.md)()<br>Immediately and violently release resources held by this web socket, discarding any enqueued messages. This does nothing if the web socket has already been closed or canceled. |
| [close](close.md) | [jvm]<br>abstract fun [close](close.md)(code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), reason: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Attempts to initiate a graceful shutdown of this web socket. Any already-enqueued messages will be transmitted before the close message is sent but subsequent calls to [send](send.md) will return false and their messages will not be enqueued. |
| [queueSize](queue-size.md) | [jvm]<br>abstract fun [queueSize](queue-size.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the size in bytes of all messages enqueued to be transmitted to the server. This doesn't include framing overhead. If compression is enabled, uncompressed messages size is used to calculate this value. It also doesn't include any bytes buffered by the operating system or network intermediaries. This method returns 0 if no messages are waiting in the queue. If may return a nonzero value after the web socket has been canceled; this indicates that enqueued messages were not transmitted. |
| [request](request.md) | [jvm]<br>abstract fun [request](request.md)(): [Request](../-request/index.md)<br>Returns the original request that initiated this web socket. |
| [send](send.md) | [jvm]<br>abstract fun [send](send.md)(text: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Attempts to enqueue `text` to be UTF-8 encoded and sent as a the data of a text (type `0x1`) message.<br>[jvm]<br>abstract fun [send](send.md)(bytes: [ByteString](https://square.github.io/okio/2.x/okio/okio/-byte-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Attempts to enqueue `bytes` to be sent as a the data of a binary (type `0x2`) message. |
