//[okhttp](../../../index.md)/[okhttp3](../index.md)/[RequestBody](index.md)/[isDuplex](is-duplex.md)

# isDuplex

[common]\
expect open fun [isDuplex](is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

A duplex request body is special in how it is **transmitted** on the network and in the **API contract** between OkHttp and the application.

This method returns false unless it is overridden by a subclass.

###  Duplex Transmission

With regular HTTP calls the request always completes sending before the response may begin receiving. With duplex the request and response may be interleaved! That is, request body bytes may be sent after response headers or body bytes have been received.

Though any call may be initiated as a duplex call, only web servers that are specially designed for this nonstandard interaction will use it. As of 2019-01, the only widely-used implementation of this pattern is [gRPC](https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md).

Because the encoding of interleaved data is not well-defined for HTTP/1, duplex request bodies may only be used with HTTP/2. Calls to HTTP/1 servers will fail before the HTTP request is transmitted. If you cannot ensure that your client and server both support HTTP/2, do not use this feature.

###  Duplex APIs

With regular request bodies it is not legal to write bytes to the sink passed to [RequestBody.writeTo](write-to.md) after that method returns. For duplex requests bodies that condition is lifted. Such writes occur on an application-provided thread and may occur concurrently with reads of the [ResponseBody](../-response-body/index.md). For duplex request bodies, [writeTo](write-to.md) should return quickly, possibly by handing off the provided request body to another thread to perform writing.

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open fun [isDuplex](is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)
