//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[writeTimeout](write-timeout.md)

# writeTimeout

[jvm]\
fun [writeTimeout](write-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)

@IgnoreJRERequirement

fun [writeTimeout](write-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)

Sets the default write timeout for new connections. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds.

The write timeout is applied for individual write IO operations. The default value is 10 seconds.

#### See also

jvm

| |
|---|
| [Sink.timeout](https://square.github.io/okio/2.x/okio/okio/-sink/timeout.html) |
