//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[queryParameterName](query-parameter-name.md)

# queryParameterName

[jvm]\
fun [queryParameterName](query-parameter-name.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

Returns the name of the query parameter at `index`. For example this returns `"a"` for `queryParameterName(0)` on `http://host/?a=apple&b=banana`. This throws if `index` is not less than the [query size](query-size.md).

| URL | `queryParameterName(0)` | `queryParameterName(1)` |
|---|---|---|
| `http://host/` | exception | exception |
| `http://host/?` | `""` | exception |
| `http://host/?a=apple&k=key+lime` | `"a"` | `"k"` |
| `http://host/?a=apple&a=apricot` | `"a"` | `"a"` |
| `http://host/?a=apple&b` | `"a"` | `"b"` |
