//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Dispatcher](index.md)/[idleCallback](idle-callback.md)

# idleCallback

[jvm]\

@get:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)

@set:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)

var [idleCallback](idle-callback.md): [Runnable](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)? = null

A callback to be invoked each time the dispatcher becomes idle (when the number of running calls returns to zero).

Note: The time at which a [call](../-call/index.md) is considered idle is different depending on whether it was run [asynchronously](../-call/enqueue.md) or [synchronously](../-call/execute.md). Asynchronous calls become idle after the onResponse or onFailure callback has returned. Synchronous calls become idle once [execute()](../-call/execute.md) returns. This means that if you are doing synchronous calls the network layer will not truly be idle until every returned [Response](../-response/index.md) has been closed.
