//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Call](index.md)

# Call

[common]\
expect interface [Call](index.md)

A call is a request that has been prepared for execution. A call can be canceled. As this object represents a single request/response pair (stream), it cannot be executed twice.

[jvm]\
actual interface [Call](index.md) : [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html)

[nonJvm]\
actual interface [Call](index.md)

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun interface [Factory](-factory/index.md)<br>[jvm, nonJvm]<br>actual fun interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | [common]<br>expect abstract fun [cancel](cancel.md)()<br>Cancels the request, if possible. Requests that are already complete cannot be canceled.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [cancel](cancel.md)() |
| [clone](clone.md) | [common]<br>expect abstract fun [clone](clone.md)(): [Call](index.md)<br>Create a new, identical call to this one which can be enqueued or executed even if this call has already been.<br>[jvm, nonJvm]<br>[jvm]<br>actual abstract override fun [clone](clone.md)(): [Call](index.md)<br>[nonJvm]<br>actual abstract fun [clone](clone.md)(): [Call](index.md) |
| [enqueue](enqueue.md) | [common]<br>expect abstract fun [enqueue](enqueue.md)(responseCallback: [Callback](../-callback/index.md))<br>Schedules the request to be executed at some point in the future.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [enqueue](enqueue.md)(responseCallback: Callback) |
| [execute](execute.md) | [jvm]<br>abstract fun [execute](execute.md)(): [Response](../-response/index.md)<br>Invokes the request immediately, and blocks until the response can be processed or is in error. |
| [executeAsync](execute-async.md) | [nonJvm]<br>abstract suspend fun [executeAsync](execute-async.md)(): [Response](../-response/index.md)<br>Invokes the request immediately, and blocks until the response can be processed or is in error. |
| [isCanceled](is-canceled.md) | [common, jvm, nonJvm]<br>[common]<br>expect abstract fun [isCanceled](is-canceled.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>actual abstract fun [isCanceled](is-canceled.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isExecuted](is-executed.md) | [common]<br>expect abstract fun [isExecuted](is-executed.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this call has been either execute or [enqueued](enqueue.md). It is an error to execute a call more than once.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [isExecuted](is-executed.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [request](request.md) | [common]<br>expect abstract fun [request](request.md)(): [Request](../-request/index.md)<br>Returns the original request that initiated this call.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [request](request.md)(): [Request](../-request/index.md) |
| [timeout](timeout.md) | [jvm]<br>abstract fun [timeout](timeout.md)(): [Timeout](https://square.github.io/okio/2.x/okio/okio/-timeout/index.html)<br>Returns a timeout that spans the entire call: resolving DNS, connecting, writing the request body, server processing, and reading the response body. If the call requires redirects or retries all must complete within one timeout period. |
