//[okhttp](../../../index.md)/[okhttp3](../index.md)/[CacheControl](index.md)

# CacheControl

[common]\
expect class [CacheControl](index.md)

A Cache-Control header with cache directives from a server or client. These directives set policy on what responses can be stored, and which requests can be satisfied by those stored responses.

See [RFC 7234, 5.2](https://tools.ietf.org/html/rfc7234#section-5.2).

[jvm, nonJvm]\
actual class [CacheControl](index.md)

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [common]<br>expect class [Builder](-builder/index.md)<br>Builds a `Cache-Control` request header.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual class [Builder](-builder/index.md) |
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [toString](to-string.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>actual open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [immutable](immutable.md) | [common]<br>expect val [immutable](immutable.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;immutable&quot;)<br>actual val [immutable](immutable.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [immutable](immutable.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isPrivate](is-private.md) | [common]<br>expect val [isPrivate](is-private.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>actual val [isPrivate](is-private.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isPublic](is-public.md) | [common]<br>expect val [isPublic](is-public.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>actual val [isPublic](is-public.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [maxAgeSeconds](max-age-seconds.md) | [common]<br>expect val [maxAgeSeconds](max-age-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The duration past the response's served date that it can be served without validation.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;maxAgeSeconds&quot;)<br>actual val [maxAgeSeconds](max-age-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual val [maxAgeSeconds](max-age-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [maxStaleSeconds](max-stale-seconds.md) | [common]<br>expect val [maxStaleSeconds](max-stale-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;maxStaleSeconds&quot;)<br>actual val [maxStaleSeconds](max-stale-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual val [maxStaleSeconds](max-stale-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [minFreshSeconds](min-fresh-seconds.md) | [common]<br>expect val [minFreshSeconds](min-fresh-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;minFreshSeconds&quot;)<br>actual val [minFreshSeconds](min-fresh-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual val [minFreshSeconds](min-fresh-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [mustRevalidate](must-revalidate.md) | [common]<br>expect val [mustRevalidate](must-revalidate.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;mustRevalidate&quot;)<br>actual val [mustRevalidate](must-revalidate.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [mustRevalidate](must-revalidate.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [noCache](no-cache.md) | [common]<br>expect val [noCache](no-cache.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>In a response, this field's name &quot;no-cache&quot; is misleading. It doesn't prevent us from caching the response; it only means we have to validate the response with the origin server before returning it. We can do this with a conditional GET.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;noCache&quot;)<br>actual val [noCache](no-cache.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [noCache](no-cache.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [noStore](no-store.md) | [common]<br>expect val [noStore](no-store.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>If true, this response should not be cached.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;noStore&quot;)<br>actual val [noStore](no-store.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [noStore](no-store.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [noTransform](no-transform.md) | [common]<br>expect val [noTransform](no-transform.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;noTransform&quot;)<br>actual val [noTransform](no-transform.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [noTransform](no-transform.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onlyIfCached](only-if-cached.md) | [common]<br>expect val [onlyIfCached](only-if-cached.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>This field's name &quot;only-if-cached&quot; is misleading. It actually means &quot;do not use the network&quot;. It is set by a client who only wants to make a request if it can be fully satisfied by the cache. Cached responses that would require validation (ie. conditional gets) are not permitted if this header is set.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;onlyIfCached&quot;)<br>actual val [onlyIfCached](only-if-cached.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [onlyIfCached](only-if-cached.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [sMaxAgeSeconds](s-max-age-seconds.md) | [common]<br>expect val [sMaxAgeSeconds](s-max-age-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The &quot;s-maxage&quot; directive is the max age for shared caches. Not to be confused with &quot;max-age&quot; for non-shared caches, As in Firefox and Chrome, this directive is not honored by this cache.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;sMaxAgeSeconds&quot;)<br>actual val [sMaxAgeSeconds](s-max-age-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual val [sMaxAgeSeconds](s-max-age-seconds.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
